#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>

static void decode_size(unsigned long x)
{
    const char *lut[] = {"No", "One", "Two", "Four"};

    printf("k%sByteCode", lut[x & 3]);
}

int main(int argc, char *argv[])
{
    unsigned long x;

    if (argc < 2) {
        fprintf(stderr, "usage: decrypt-mixed-call <param>\n");
        return 1;
    }

    x = strtoul(argv[1], NULL, 0);

    switch (x & 15) {
    case 0:
        printf("kPascalStackBased");
        break;
    case 1:
        printf("kCStackBased");
        break;
    case 2:
        printf("I'm too lazy for this!");
        return 1;
    case 5:
        printf("kThinkCStackBased");
        break;
    case 8:
        printf("kD0DispatchedPascalStackBased");
        break;
    case 9:
        printf("kD0DispatchedCStackBased");
        break;
    case 12:
        printf("kD1DispatchedPascalStackBased");
        break;
    case 14:
        printf("kStackDispatchedPascalStackBased");
        break;
    default:
        /* Invalid */
        return 1;
    }

    x >>= 4;

    printf(" | RESULT_SIZE(");
    decode_size(x);
    printf(")");

    /* trim the fat */
    x >>= 2;

    /* hopefully we're using stack, since that's the ONLY thing i'm handling */
    for (uint32_t i = 1; i < 13 && x; i++, x >>= 2) {
        printf(" | STACK_ROUTINE_PARAMETER(%" PRIu32 ", ", i);
        decode_size(x);
        printf(")");
    }

    puts("");

    return 0;
}
