#!/usr/bin/env python3
import glob
import subprocess

# list of Popen classes to wait on
# this allows us to run metaflac independently on
# a huge list of files concurrently
processes = list()

i = 1

# glob the files in order
files = glob.glob("*.flac")
files.sort()
for g in files:
	processes.append(subprocess.Popen(["metaflac", "--set-tag=TRACKNUMBER=%d" % (i), g]))
	i += 1

for p in processes:
	p.wait()
