/* internal crc32 definitions */

#include "crc32.h"

#define CRC32_API __attribute__((__visibility__("default")))

/* all LUTs etc. are generated at compile time.
 * eventually, I'd like to have all internal info
 * stored in one opaque pointer. this pointer will
 * contain the LUTs (or maybe a pointer to one).
 * We could also create these structures at compile
 * time and have a flag that says whether it needs
 * to be destroyed or if it can be cached. */
#define CRC32_POLYNOMIAL 0xedb88320

/* crc32b.c */
#ifdef __GNUC__
# define CRC32_PURE __attribute__((__pure__))
#else
# define CRC32_PURE
#endif

#define ALIGNOF(type) offsetof(struct { type a; char b; }, b)
#define ALIGNED(ptr, alignment) (((uintptr_t)(ptr) % (alignment)) == 0)
#define ALIGNED_TYPE(ptr, type) ALIGNED(ptr, ALIGNOF(type))

typedef uint32_t (*crc32_r_spec)(uint32_t, const unsigned char *, size_t);

/* shared by crc32c and crc32qw */
extern const uint32_t crc32_tab[256];

/* Calculates crc32 by bytes. Has no alignment requirement */
uint32_t crc32c_r(uint32_t crc, const unsigned char *message, size_t sz);
/* Calculates crc32 in dwords. Requires 4-byte alignment */
uint32_t crc32qw_r(uint32_t crc, const unsigned char *message, size_t sz);
/* Calculates crc32 using intel SIMD. Requires 16-byte alignment */
uint32_t crc32x86_vpclmulqdq_r(uint32_t crc, const unsigned char *msg, size_t sz);

/* Maximum alignment value for each impl to work */
#define MAX(x, y) ((x)>(y)?(x):(y))
#define MIN(x, y) ((x)<(y)?(x):(y))
#define CRC32_MAX_ALIGNMENT MAX(16, ALIGNOF(uint32_t))

#define ARRAY_SIZE(x) (sizeof(x)/sizeof((x)[0]))

