/* internal crc32 definitions */

#include "crc32.h"

#define CRC32_API __attribute__((__visibility__("default")))

/* all LUTs etc. are generated at compile time.
 * eventually, I'd like to have all internal info
 * stored in one opaque pointer. this pointer will
 * contain the LUTs (or maybe a pointer to one).
 * We could also create these structures at compile
 * time and have a flag that says whether it needs
 * to be destroyed or if it can be cached. */
#define CRC32_POLYNOMIAL 0xedb88320

#if (__STDC_VERSION__ >= 201112L)
# define CRC32_ALIGN(N) alignas(N)
#elif defined(__GNUC__)
# define CRC32_ALIGN(N) __attribute__((__aligned__(N)))
#elif defined(_MSC_VER)
# define CRC32_ALIGN(N) __declspec(align(N))
#else
# error fuck
#endif

#ifdef __GNUC__
# define CRC32_FORCEINLINE static inline __attribute__((__always_inline__))
#elif defined(_MSC_VER)
# define CRC32_FORCEINLINE static __forceinline
#else
# define CRC32_FORCEINLINE static inline
#endif

#define ALIGNOF(type) offsetof(struct { type a; char b; }, b)
#define ALIGNED(ptr, alignment) (((uintptr_t)(ptr) % (alignment)) == 0)
#define ALIGNED_TYPE(ptr, type) ALIGNED(ptr, ALIGNOF(type))

typedef uint32_t (*crc32_r_spec)(uint32_t, const unsigned char *, size_t);

/* shared by crc32c and crc32qw */
extern const uint32_t crc32_tab[256];

/* declare */
#define CRC32_IMPL(name) uint32_t crc32##name##_r(uint32_t, const unsigned char *, size_t);
#include "crc32-impls.h"

/* Maximum alignment value for each impl to work */
#define MAX(x, y) ((x)>(y)?(x):(y))
#define MIN(x, y) ((x)<(y)?(x):(y))
#define CRC32_MAX_ALIGNMENT MAX(16, ALIGNOF(uint32_t))

#define ARRAY_SIZE(x) (sizeof(x)/sizeof((x)[0]))

