#include "crc32i.h"
#include <stdio.h>

/* Test implementations and make sure they agree with each other */
int crc32_test(void)
{
	/* Force alignment :) */
	static const __attribute__((__aligned__(CRC32_MAX_ALIGNMENT))) unsigned char testdata[1024] =
#define DOUBLE(x) x x
DOUBLE(DOUBLE(DOUBLE(DOUBLE(DOUBLE(DOUBLE(DOUBLE("\x01\x02\x04\x08\x10\x20\x40\x80")))))))
#undef DOUBLE
	;
	static const crc32_r_spec crc[] = {
#define CRC32_IMPL(name) crc32##name##_r,
#include "crc32-impls.h"
	};
	size_t i;

	uint32_t crcc = crc32(testdata, sizeof(testdata));

	for (i = 0; i < ARRAY_SIZE(crc); i++) {
		uint32_t thiscrc = ~crc[i](0xFFFFFFFF, testdata, sizeof(testdata));

		if (thiscrc != crcc) {
			fprintf(stderr, "%zu, mismatch: %08x, %08x\n", i, crcc, thiscrc);
			return -1;
		}
	}

	return 0;
}

int main(void)
{
	return -crc32_test();
}
