#include "crc32i.h"
#include <stdio.h>
#include <inttypes.h>
#include <time.h>

/* Test implementations and make sure they agree with each other */
int crc32_test(void)
{
	/* Force alignment :) */
	static const CRC32_ALIGN(CRC32_MAX_ALIGNMENT) unsigned char testdata[(1ul << 23) + 19] =
#define DOUBLE(x) x x
DOUBLE(DOUBLE(DOUBLE(DOUBLE(DOUBLE(DOUBLE(DOUBLE(DOUBLE("\x01\x02\x04\x08\x10\x20\x40\x80"))))))))
#undef DOUBLE
	;
	static const struct {
		crc32_r_spec f;
		const char *name;
	} crc[] = {
#define CRC32_IMPL(name) {crc32##name##_r, #name},
#include "crc32-impls.h"
	};
	size_t i;

	uint32_t crcc = crc32(testdata, sizeof(testdata));

	for (i = 0; i < ARRAY_SIZE(crc); i++) {
		clock_t start, end;

		start = clock();
		uint32_t thiscrc = crc[i].f(0xFFFFFFFF, testdata, sizeof(testdata));
		end = clock();

		printf("%s: took %f secs\n", crc[i].name, (double)(end - start) / CLOCKS_PER_SEC);

		thiscrc = ~thiscrc;

		if (thiscrc != crcc) {
			fprintf(stderr, "%s: mismatch: %08" PRIX32 ", %08" PRIx32 "\n", crc[i].name, crcc, thiscrc);
			return -1;
		}
	}

	return 0;
}

int main(void)
{
	return -crc32_test();
}
