#!/bin/bash

set -e

script_dir="$(dirname $(readlink -f $0))"
out_file="cmake/FileLists.cmake"

function write_prologue()
{
    echo "# Generated by $(basename $0)" >> "$out_file"
}

function dump_dir()
{
    (
        printf '\nset(\n    %s\n' "$1"
        ls $2 | grep -viE "$IGNORE$" | xargs -n1 --no-run-if-empty printf '    %s\n'
        printf ')\n'
    ) >> "$out_file"
}

function dump_vcxproj()
{
    export VCXPROJ_IGNORE="$IGNORE$"

    "$script_dir/dump-vcxproj.sh" $1 $2 $3 >> "$out_file"
}

IGNORE="stdafx\\.cpp"

cd "$script_dir/.."
rm -f $out_file || true
mkdir -p $(dirname $out_file)

write_prologue

dump_dir WTL_HEADERS    'wtl/Include/*.h'
dump_dir SHARED_HEADERS 'sdk/foobar2000/shared/*.h'

IGNORE="($IGNORE)|(pfc-fb2k-hooks\\.cpp)|(nix-objects\\.(cpp|h))" \
    dump_vcxproj PFC \
    sdk/pfc/pfc.vcxproj

dump_vcxproj SDK \
    sdk/foobar2000/SDK/foobar2000_SDK.vcxproj \
    --skip-headers

dump_dir SDK_HEADERS \
    'sdk/foobar2000/SDK/*.h'

IGNORE="($IGNORE)|(TypeFind\\.h)" \
    dump_vcxproj SDK_HELPERS \
    sdk/foobar2000/helpers/foobar2000_sdk_helpers.vcxproj

dump_vcxproj PPUI \
    sdk/libPPUI/libPPUI.vcxproj

dump_vcxproj COMPONENT_CLIENT \
    sdk/foobar2000/foobar2000_component_client/foobar2000_component_client.vcxproj \
    --skip-headers

IGNORE="($IGNORE)|(PCH\\.cpp)" dump_vcxproj SAMPLE \
    sdk/foobar2000/foo_sample/foo_sample.vcxproj
