#pragma once

#pragma comment(lib, "uxtheme.lib")

#include "wtl-pp.h"
#include "win32_op.h"

// Separator-in-dialog tool: subclass a static control on init
class CStaticSeparator : public CWindowImpl<CStaticSeparator, CStatic> {
public:
	CStaticSeparator() {}
	BEGIN_MSG_MAP_EX(CSeparator)
		MSG_WM_PAINT(OnPaint)
		MSG_WM_SETTEXT(OnSetText)
	END_MSG_MAP()
private:
	int OnSetText(LPCTSTR) {
		Invalidate();
		SetMsgHandled(FALSE);
		return 0;
	}
	void OnPaint(CDCHandle);
};

// CWindowRegistered with font & text functionality, for creating custom text label classes
template<typename TClass>
class CTextControl : public CWindowRegisteredT<TClass> {
public:
	BEGIN_MSG_MAP_EX(CTextControl)
		MSG_WM_SETFONT(OnSetFont)
		MSG_WM_GETFONT(OnGetFont)
		MSG_WM_SETTEXT(OnSetText)
		CHAIN_MSG_MAP(__super)
	END_MSG_MAP()
private:
	HFONT OnGetFont() {
		return m_font;
	}
	void OnSetFont(HFONT font, BOOL bRedraw) {
		m_font = font;
		if (bRedraw) this->Invalidate();
	}
	int OnSetText(LPCTSTR) {
		this->Invalidate();this->SetMsgHandled(FALSE); return 0;
	}
	CFontHandle m_font;
};

// CStaticThemed BROKEN WITH DARK MODE, DO NOT USE
// CStaticMainInstruction = use 1.5x scaled font for non subclassed static instead
#if 0 
// Static control subclass with override for theme part used for rendering
class CStaticThemed : public CWindowImpl<CStaticThemed, CStatic> {
public:
	CStaticThemed() : m_id(), m_fallback() {}
	BEGIN_MSG_MAP_EX(CStaticThemed)
		MSG_WM_PAINT(OnPaint)
		MSG_WM_THEMECHANGED(OnThemeChanged)
		MSG_WM_SETTEXT(OnSetText)
	END_MSG_MAP()

	void SetThemePart(int id) {m_id = id; if (m_hWnd != NULL) Invalidate();}
private:
	int OnSetText(LPCTSTR) {
		Invalidate();
		SetMsgHandled(FALSE);
		return 0;
	}
	void OnThemeChanged() {
		m_theme.Release();
		m_fallback = false;
	}
	void OnPaint(CDCHandle);
	int m_id;
	CTheme m_theme;
	bool m_fallback;
};

class CStaticMainInstruction : public CStaticThemed {
public:
	CStaticMainInstruction();
};
#endif


class CSeparator : public CTextControl<CSeparator> {
public:
	BEGIN_MSG_MAP_EX(CSeparator)
		MSG_WM_PAINT(OnPaint)
		MSG_WM_ENABLE(OnEnable)
		CHAIN_MSG_MAP(__super)
	END_MSG_MAP()

	static const TCHAR * GetClassName() {
		return _T("foobar2000:separator");
	}
private:
	void OnEnable(BOOL) {
		Invalidate();
	}
	void OnPaint(CDCHandle dc);
};

