#include "pfc-lite.h"
#include "charDownConvert.h"
#include "SmartStrStr-twoCharMappings.h"

namespace {
    static constexpr pfc::CharDownConvert::charMapping_t g_mappings[] = {
        {65,97},{66,98},{67,99},{68,100},{69,101},{70,102},{71,103},{72,104},{73,105},{74,106},{75,107},{76,108},{77,109},{78,110},{79,111},{80,112},{81,113},{82,114},{83,115},{84,116},{85,117},{86,118},{87,119},
        {88,120},{89,121},{90,122},{160,32},{161,33},{162,99},{164,36},{165,89},{166,124},{169,67},{170,97},{171,60},{173,45},{174,82},{178,50},{179,51},{183,46},{184,44},{185,49},{186,111},{187,62},{192,97},{193,97},
        {194,97},{195,97},{196,97},{197,97},{198,97},{199,99},{200,101},{201,101},{202,101},{203,101},{204,105},{205,105},{206,105},{207,105},{208,240},{209,110},{210,111},{211,111},{212,111},{213,111},{214,111},
        {216,111},{217,117},{218,117},{219,117},{220,117},{221,121},{222,254},{224,97},{225,97},{226,97},{227,97},{228,97},{229,97},{230,97},{231,99},{232,101},{233,101},{234,101},{235,101},{236,105},{237,105},
        {238,105},{239,105},{241,110},{242,111},{243,111},{244,111},{245,111},{246,111},{248,111},{249,117},{250,117},{251,117},{252,117},{253,121},{255,121},{256,97},{257,97},{258,97},{259,97},{260,97},{261,97},
        {262,99},{263,99},{264,99},{265,99},{266,99},{267,99},{268,99},{269,99},{270,100},{271,100},{272,100},{273,100},{274,101},{275,101},{276,101},{277,101},{278,101},{279,101},{280,101},{281,101},{282,101},
        {283,101},{284,103},{285,103},{286,103},{287,103},{288,103},{289,103},{290,103},{291,103},{292,104},{293,104},{294,104},{295,104},{296,105},{297,105},{298,105},{299,105},{300,105},{301,105},{302,105},{303,105},
        {304,73},{305,105},{306,307},{308,106},{309,106},{310,107},{311,107},{313,108},{314,108},{315,108},{316,108},{317,108},{318,108},{319,320},{321,108},{322,108},{323,110},{324,110},{325,110},{326,110},{327,110},
        {328,110},{330,331},{332,111},{333,111},{334,111},{335,111},{336,111},{337,111},{338,111},{339,111},{340,114},{341,114},{342,114},{343,114},{344,114},{345,114},{346,115},{347,115},{348,115},{349,115},{350,115},
        {351,115},{352,115},{353,115},{354,116},{355,116},{356,116},{357,116},{358,116},{359,116},{360,117},{361,117},{362,117},{363,117},{364,117},{365,117},{366,117},{367,117},{368,117},{369,117},{370,117},{371,117},
        {372,119},{373,119},{374,121},{375,121},{376,121},{377,122},{378,122},{379,122},{380,122},{381,122},{382,122},{384,98},{385,595},{386,387},{388,389},{390,596},{391,392},{393,598},{394,599},{395,396},{398,477},
        {399,601},{400,603},{401,102},{402,102},{403,608},{404,611},{406,617},{407,616},{408,409},{410,108},{412,623},{413,626},{415,629},{416,111},{417,111},{418,419},{420,421},{422,640},{423,424},{425,643},{427,116},
        {428,429},{430,648},{431,117},{432,117},{433,650},{434,651},{435,436},{437,122},{438,122},{439,658},{440,441},{444,445},{452,454},{455,457},{458,460},{461,97},{462,97},{463,105},{464,105},{465,111},{466,111},
        {467,117},{468,117},{469,117},{470,117},{471,117},{472,117},{473,117},{474,117},{475,117},{476,117},{478,97},{479,97},{480,481},{482,483},{484,103},{485,103},{486,103},{487,103},{488,107},{489,107},{490,111},
        {491,111},{492,111},{493,111},{494,495},{496,106},{497,499},{500,501},{502,405},{503,447},{504,505},{506,507},{508,509},{510,511},{512,513},{514,515},{516,517},{518,519},{520,521},{522,523},{524,525},{526,527},
        {528,529},{530,531},{532,533},{534,535},{536,537},{538,539},{540,541},{542,543},{544,414},{546,547},{548,549},{550,551},{552,553},{554,555},{556,557},{558,559},{560,561},{562,563},{570,11365},{571,572},
        {573,108},{574,11366},{577,578},{579,98},{580,649},{581,652},{582,583},{584,585},{586,587},{588,589},{590,591},{609,103},{697,39},{698,34},{700,39},{708,94},{710,94},{712,39},{715,96},{717,95},{732,126},
        {768,96},{770,94},{771,126},{782,34},{817,95},{818,95},{880,881},{882,883},{886,887},{902,940},{904,941},{905,942},{906,943},{908,972},{910,973},{911,974},{913,945},{914,946},{915,947},{916,948},{917,949},
        {918,950},{919,951},{920,952},{921,953},{922,954},{923,955},{924,956},{925,957},{926,958},{927,959},{928,960},{929,961},{931,963},{932,964},{933,965},{934,966},{935,967},{936,968},{937,969},{938,970},{939,971},
        {975,983},{984,985},{986,987},{988,989},{990,991},{992,993},{994,995},{996,997},{998,999},{1000,1001},{1002,1003},{1004,1005},{1006,1007},{1015,1016},{1017,1010},{1018,1019},{1021,891},{1022,892},{1023,893},
        {1024,1104},{1025,1105},{1026,1106},{1027,1107},{1028,1108},{1029,1109},{1030,1110},{1031,1111},{1032,1112},{1033,1113},{1034,1114},{1035,1115},{1036,1116},{1037,1117},{1038,1118},{1039,1119},{1040,1072},
        {1041,1073},{1042,1074},{1043,1075},{1044,1076},{1045,1077},{1046,1078},{1047,1079},{1048,1080},{1049,1081},{1050,1082},{1051,1083},{1052,1084},{1053,1085},{1054,1086},{1055,1087},{1056,1088},{1057,1089},
        {1058,1090},{1059,1091},{1060,1092},{1061,1093},{1062,1094},{1063,1095},{1064,1096},{1065,1097},{1066,1098},{1067,1099},{1068,1100},{1069,1101},{1070,1102},{1071,1103},{1120,1121},{1122,1123},{1124,1125},
        {1126,1127},{1128,1129},{1130,1131},{1132,1133},{1134,1135},{1136,1137},{1138,1139},{1140,1141},{1142,1143},{1144,1145},{1146,1147},{1148,1149},{1150,1151},{1152,1153},{1162,1163},{1164,1165},{1166,1167},
        {1168,1169},{1170,1171},{1172,1173},{1174,1175},{1176,1177},{1178,1179},{1180,1181},{1182,1183},{1184,1185},{1186,1187},{1188,1189},{1190,1191},{1192,1193},{1194,1195},{1196,1197},{1198,1199},{1200,1201},
        {1202,1203},{1204,1205},{1206,1207},{1208,1209},{1210,1211},{1212,1213},{1214,1215},{1216,1231},{1217,1218},{1219,1220},{1221,1222},{1223,1224},{1225,1226},{1227,1228},{1229,1230},{1232,1233},{1234,1235},
        {1236,1237},{1238,1239},{1240,1241},{1242,1243},{1244,1245},{1246,1247},{1248,1249},{1250,1251},{1252,1253},{1254,1255},{1256,1257},{1258,1259},{1260,1261},{1262,1263},{1264,1265},{1266,1267},{1268,1269},
        {1270,1271},{1272,1273},{1274,1275},{1276,1277},{1278,1279},{1280,1281},{1282,1283},{1284,1285},{1286,1287},{1288,1289},{1290,1291},{1292,1293},{1294,1295},{1296,1297},{1298,1299},{1300,1301},{1302,1303},
        {1304,1305},{1306,1307},{1308,1309},{1310,1311},{1312,1313},{1314,1315},{1329,1377},{1330,1378},{1331,1379},{1332,1380},{1333,1381},{1334,1382},{1335,1383},{1336,1384},{1337,1385},{1338,1386},{1339,1387},
        {1340,1388},{1341,1389},{1342,1390},{1343,1391},{1344,1392},{1345,1393},{1346,1394},{1347,1395},{1348,1396},{1349,1397},{1350,1398},{1351,1399},{1352,1400},{1353,1401},{1354,1402},{1355,1403},{1356,1404},
        {1357,1405},{1358,1406},{1359,1407},{1360,1408},{1361,1409},{1362,1410},{1363,1411},{1364,1412},{1365,1413},{1366,1414},{4256,11520},{4257,11521},{4258,11522},{4259,11523},{4260,11524},{4261,11525},{4262,11526},
        {4263,11527},{4264,11528},{4265,11529},{4266,11530},{4267,11531},{4268,11532},{4269,11533},{4270,11534},{4271,11535},{4272,11536},{4273,11537},{4274,11538},{4275,11539},{4276,11540},{4277,11541},{4278,11542},
        {4279,11543},{4280,11544},{4281,11545},{4282,11546},{4283,11547},{4284,11548},{4285,11549},{4286,11550},{4287,11551},{4288,11552},{4289,11553},{4290,11554},{4291,11555},{4292,11556},{4293,11557},{7680,7681},
        {7682,7683},{7684,7685},{7686,7687},{7688,7689},{7690,7691},{7692,7693},{7694,7695},{7696,7697},{7698,7699},{7700,7701},{7702,7703},{7704,7705},{7706,7707},{7708,7709},{7710,7711},{7712,7713},{7714,7715},
        {7716,7717},{7718,7719},{7720,7721},{7722,7723},{7724,7725},{7726,7727},{7728,7729},{7730,7731},{7732,7733},{7734,7735},{7736,7737},{7738,7739},{7740,7741},{7742,7743},{7744,7745},{7746,7747},{7748,7749},
        {7750,7751},{7752,7753},{7754,7755},{7756,7757},{7758,7759},{7760,7761},{7762,7763},{7764,7765},{7766,7767},{7768,7769},{7770,7771},{7772,7773},{7774,7775},{7776,7777},{7778,7779},{7780,7781},{7782,7783},
        {7784,7785},{7786,7787},{7788,7789},{7790,7791},{7792,7793},{7794,7795},{7796,7797},{7798,7799},{7800,7801},{7802,7803},{7804,7805},{7806,7807},{7808,7809},{7810,7811},{7812,7813},{7814,7815},{7816,7817},
        {7818,7819},{7820,7821},{7822,7823},{7824,7825},{7826,7827},{7828,7829},{7840,7841},{7842,7843},{7844,7845},{7846,7847},{7848,7849},{7850,7851},{7852,7853},{7854,7855},{7856,7857},{7858,7859},{7860,7861},
        {7862,7863},{7864,7865},{7866,7867},{7868,7869},{7870,7871},{7872,7873},{7874,7875},{7876,7877},{7878,7879},{7880,7881},{7882,7883},{7884,7885},{7886,7887},{7888,7889},{7890,7891},{7892,7893},{7894,7895},
        {7896,7897},{7898,7899},{7900,7901},{7902,7903},{7904,7905},{7906,7907},{7908,7909},{7910,7911},{7912,7913},{7914,7915},{7916,7917},{7918,7919},{7920,7921},{7922,7923},{7924,7925},{7926,7927},{7928,7929},
        {7930,7931},{7932,7933},{7934,7935},{7944,7936},{7945,7937},{7946,7938},{7947,7939},{7948,7940},{7949,7941},{7950,7942},{7951,7943},{7960,7952},{7961,7953},{7962,7954},{7963,7955},{7964,7956},{7965,7957},
        {7976,7968},{7977,7969},{7978,7970},{7979,7971},{7980,7972},{7981,7973},{7982,7974},{7983,7975},{7992,7984},{7993,7985},{7994,7986},{7995,7987},{7996,7988},{7997,7989},{7998,7990},{7999,7991},{8008,8000},
        {8009,8001},{8010,8002},{8011,8003},{8012,8004},{8013,8005},{8025,8017},{8027,8019},{8029,8021},{8031,8023},{8040,8032},{8041,8033},{8042,8034},{8043,8035},{8044,8036},{8045,8037},{8046,8038},{8047,8039},
        {8072,8064},{8073,8065},{8074,8066},{8075,8067},{8076,8068},{8077,8069},{8078,8070},{8079,8071},{8088,8080},{8089,8081},{8090,8082},{8091,8083},{8092,8084},{8093,8085},{8094,8086},{8095,8087},{8104,8096},
        {8105,8097},{8106,8098},{8107,8099},{8108,8100},{8109,8101},{8110,8102},{8111,8103},{8120,8112},{8121,8113},{8122,8048},{8123,8049},{8124,8115},{8136,8050},{8137,8051},{8138,8052},{8139,8053},{8140,8131},
        {8152,8144},{8153,8145},{8154,8054},{8155,8055},{8168,8160},{8169,8161},{8170,8058},{8171,8059},{8172,8165},{8184,8056},{8185,8057},{8186,8060},{8187,8061},{8188,8179},{8192,32},{8193,32},{8194,32},{8195,32},
        {8196,32},{8197,32},{8198,32},{8208,45},{8209,45},{8211,45},{8212,45},{8216,39},{8217,39},{8218,44},{8220,34},{8221,34},{8222,34},{8226,46},{8230,46},{8242,39},{8245,96},{8249,60},{8250,62},{8482,84},{8498,8526},
        {8544,8560},{8545,8561},{8546,8562},{8547,8563},{8548,8564},{8549,8565},{8550,8566},{8551,8567},{8552,8568},{8553,8569},{8554,8570},{8555,8571},{8556,8572},{8557,8573},{8558,8574},{8559,8575},{8579,8580},
        {9398,9424},{9399,9425},{9400,9426},{9401,9427},{9402,9428},{9403,9429},{9404,9430},{9405,9431},{9406,9432},{9407,9433},{9408,9434},{9409,9435},{9410,9436},{9411,9437},{9412,9438},{9413,9439},{9414,9440},
        {9415,9441},{9416,9442},{9417,9443},{9418,9444},{9419,9445},{9420,9446},{9421,9447},{9422,9448},{9423,9449},{11264,11312},{11265,11313},{11266,11314},{11267,11315},{11268,11316},{11269,11317},{11270,11318},
        {11271,11319},{11272,11320},{11273,11321},{11274,11322},{11275,11323},{11276,11324},{11277,11325},{11278,11326},{11279,11327},{11280,11328},{11281,11329},{11282,11330},{11283,11331},{11284,11332},{11285,11333},
        {11286,11334},{11287,11335},{11288,11336},{11289,11337},{11290,11338},{11291,11339},{11292,11340},{11293,11341},{11294,11342},{11295,11343},{11296,11344},{11297,11345},{11298,11346},{11299,11347},{11300,11348},
        {11301,11349},{11302,11350},{11303,11351},{11304,11352},{11305,11353},{11306,11354},{11307,11355},{11308,11356},{11309,11357},{11310,11358},{11360,11361},{11362,619},{11363,7549},{11364,637},{11367,11368},
        {11369,11370},{11371,11372},{11373,593},{11374,625},{11375,592},{11378,11379},{11381,11382},{11392,11393},{11394,11395},{11396,11397},{11398,11399},{11400,11401},{11402,11403},{11404,11405},{11406,11407},
        {11408,11409},{11410,11411},{11412,11413},{11414,11415},{11416,11417},{11418,11419},{11420,11421},{11422,11423},{11424,11425},{11426,11427},{11428,11429},{11430,11431},{11432,11433},{11434,11435},{11436,11437},
        {11438,11439},{11440,11441},{11442,11443},{11444,11445},{11446,11447},{11448,11449},{11450,11451},{11452,11453},{11454,11455},{11456,11457},{11458,11459},{11460,11461},{11462,11463},{11464,11465},{11466,11467},
        {11468,11469},{11470,11471},{11472,11473},{11474,11475},{11476,11477},{11478,11479},{11480,11481},{11482,11483},{11484,11485},{11486,11487},{11488,11489},{11490,11491},{42560,42561},{42562,42563},{42564,42565},
        {42566,42567},{42568,42569},{42570,42571},{42572,42573},{42574,42575},{42576,42577},{42578,42579},{42580,42581},{42582,42583},{42584,42585},{42586,42587},{42588,42589},{42590,42591},{42594,42595},{42596,42597},
        {42598,42599},{42600,42601},{42602,42603},{42604,42605},{42624,42625},{42626,42627},{42628,42629},{42630,42631},{42632,42633},{42634,42635},{42636,42637},{42638,42639},{42640,42641},{42642,42643},{42644,42645},
        {42646,42647},{42786,42787},{42788,42789},{42790,42791},{42792,42793},{42794,42795},{42796,42797},{42798,42799},{42802,42803},{42804,42805},{42806,42807},{42808,42809},{42810,42811},{42812,42813},{42814,42815},
        {42816,42817},{42818,42819},{42820,42821},{42822,42823},{42824,42825},{42826,42827},{42828,42829},{42830,42831},{42832,42833},{42834,42835},{42836,42837},{42838,42839},{42840,42841},{42842,42843},{42844,42845},
        {42846,42847},{42848,42849},{42850,42851},{42852,42853},{42854,42855},{42856,42857},{42858,42859},{42860,42861},{42862,42863},{42873,42874},{42875,42876},{42877,7545},{42878,42879},{42880,42881},{42882,42883},
        {42884,42885},{42886,42887},{42891,42892},{65281,33},{65282,34},{65283,35},{65284,36},{65285,37},{65286,38},{65287,39},{65288,40},{65289,41},{65290,42},{65291,43},{65292,44},{65293,45},{65294,46},{65295,47},
        {65296,48},{65297,49},{65298,50},{65299,51},{65300,52},{65301,53},{65302,54},{65303,55},{65304,56},{65305,57},{65306,58},{65307,59},{65308,60},{65309,61},{65310,62},{65312,64},{65313,97},{65314,98},{65315,99},
        {65316,100},{65317,101},{65318,102},{65319,103},{65320,104},{65321,105},{65322,106},{65323,107},{65324,108},{65325,109},{65326,110},{65327,111},{65328,112},{65329,113},{65330,114},{65331,115},{65332,116},
        {65333,117},{65334,118},{65335,119},{65336,120},{65337,121},{65338,122},{65339,91},{65340,92},{65341,93},{65342,94},{65343,95},{65344,96},{65345,97},{65346,98},{65347,99},{65348,100},{65349,101},{65350,102},
        {65351,103},{65352,104},{65353,105},{65354,106},{65355,107},{65356,108},{65357,109},{65358,110},{65359,111},{65360,112},{65361,113},{65362,114},{65363,115},{65364,116},{65365,117},{65366,118},{65367,119},
        {65368,120},{65369,121},{65370,122},{65371,123},{65372,124},{65373,125},{65374,126},
    };
}

namespace pfc {

    const CharDownConvert::charMapping_t* CharDownConvert::mappings() { return g_mappings; }
    size_t CharDownConvert::numMappings() { return std::size(g_mappings); }

    CharDownConvert::CharDownConvert() {
        std::map<uint32_t, CharStorage> charConvertMap;

        for (auto& l : g_mappings) {
            charConvertMap[(uint32_t)l.from] = (uint32_t)l.to;
        }
        for (auto& line : twoCharMappings) {
            charConvertMap[line.from] = line.to;
        }

        m_charConvertMap.initialize(std::move(charConvertMap));
    }

    void CharDownConvert::TransformCharCachedAppend(t_uint32 c, pfc::string_base& out) {
        auto subst = m_charConvertMap.query_ptr(c);
        if (subst != nullptr) {
            out << subst->ptr();
        } else {
            out.add_char(c);
        }
    }
    void CharDownConvert::TransformStringHere(pfc::string_base& out, const char* src, size_t len) {
        out.reset(); this->TransformStringAppend(out, src, len);
    }

    void CharDownConvert::TransformStringAppend(pfc::string_base& out, const char* src, size_t len) {
        size_t walk = 0;
        while(walk < len) {
            char c = src[walk];
            if (c > 0) {
                out.add_byte(pfc::ascii_tolower_lookup(c));
                ++walk;
            } else if (c == 0) {
                break;
            } else {
                unsigned wc; t_size d;
                d = pfc::utf8_decode_char(src + walk, wc, len - walk);
                if (d == 0) break;
                TransformCharCachedAppend(wc, out);
                walk += d;
            }
        }
    }

    CharDownConvert& CharDownConvert::instance() {
        static CharDownConvert obj; return obj;
    }
} // namespace pfc