#ifndef ANIMONE_ANIMONE_TYPES_H_
#define ANIMONE_ANIMONE_TYPES_H_

#include <cstdint>

/* windows is so annoying */
#ifdef ANIMONE_STATIC
# define ANIMONE_API
#else
# ifdef _WIN32
#  ifdef DLL_EXPORT
#   define ANIMONE_API __declspec(dllexport)
#  else
#   define ANIMONE_API __declspec(dllimport)
#  endif
# else
#  define ANIMONE_API
# endif
#endif

/* FIXME configure this in autoconf */
#ifndef _WIN32
#include <sys/types.h>
#endif

namespace animone::internal {

#ifdef _WIN32
using pid_t = std::uint32_t;
#else
using pid_t = ::pid_t;
#endif

/* different window systems have different sized IDs */
union ANIMONE_API wid_t {
	std::uintptr_t win32;
	std::int64_t quartz; // FIXME is this correct?
	std::uint32_t x11;
};

}

#endif // ANIMONE_ANIMONE_TYPES_H_
