#ifndef ANIMONE_ANIMONE_PLAYER_H_
#define ANIMONE_ANIMONE_PLAYER_H_

#include "animone/types.h"

#include <string>
#include <vector>
#include <map>

namespace animone {

/* TODO convert to plain C enums */
enum class ExecutablePlatform {
	Unknown, // ...
	Posix,   // Posix platforms that aren't OS X
	Win32,   // Windows
	Xnu,     // OS X
};

enum class WindowPlatform {
	Unknown, // ...
	Quartz,  // OS X
	Win32,   // Windows
	X11,     // X11
};

enum class Strategy {
	WindowTitle,
	OpenFiles,
	UiAutomation,
};

enum class PlayerType {
	Default,
	WebBrowser,
};

struct ANIMONE_API Player {
	PlayerType type = PlayerType::Default;
	std::string name;
	std::string window_title_format;
	std::map<WindowPlatform, std::vector<std::string>> windows;
	std::map<ExecutablePlatform, std::vector<std::string>> executables;
	std::vector<Strategy> strategies;
};

}

#ifdef __cplusplus
extern "C" {
#endif

int animone_ParsePlayersData(const char *data, std::vector<animone::Player>& players);
int animone_ParsePlayersData(const char *path, std::vector<animone::Player>& players);

#ifdef __cplusplus
}

namespace animone {

inline bool ParsePlayersData(const std::string& data, std::vector<Player>& players)
{
	return !!ParsePlayersData(data.c_str(), players);
}
inline bool ParsePlayersFile(const std::string& path, std::vector<Player>& players)
{
	return !!ParsePlayersFile(path.c_str(), players);
}

}

#endif

#endif // ANIMONE_ANIMONE_PLAYER_H_