#ifndef ANIMONE_ANIMONE_UTIL_H_
#define ANIMONE_ANIMONE_UTIL_H_

#include <stdint.h>
#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

int animone_internal_util_ReadFile(const char *path, char **data, size_t *size);
int animone_internal_util_EqualStrings(const char *str1, const char *str2);
char *animone_internal_util_Stem(const char *filename);
int animone_internal_util_CheckPattern(const char *pattern, const char *str);
int animone_internal_util_TrimLeft(char *str, const char* chars);
int animone_internal_util_TrimRight(char *str, const char* chars);

intmax_t animone_internal_util_StringToInt(const char *ptr, intmax_t def);

#ifdef __cplusplus
}

#include <string>
#include <cstdlib>

namespace animone {
namespace internal {
namespace util {

// Compatibility bindings, to keep the existing C++ code working
inline bool ReadFile(const std::string &path, std::string &data)
{
	char *data_c;
	size_t size_c;

	int x = ::animone_internal_util_ReadFile(path.c_str(), &data_c, &size_c);

	data.assign(data_c, size_c);

	std::free(data_c);

	return static_cast<bool>(x);
}

inline bool EqualStrings(const std::string &str1, const std::string &str2)
{
	return static_cast<bool>(::animone_internal_util_EqualStrings(str1.c_str(), str2.c_str()));
}

inline bool Stem(const std::string &filename, std::string &stem)
{
	char *stem_c = ::animone_internal_util_Stem(filename.c_str());
	if (!stem_c)
		return 0;

	stem.assign(stem_c);

	std::free(stem_c);

	return 1;
}

inline bool CheckPattern(const std::string &pattern, const std::string &str)
{
	return static_cast<bool>(::animone_internal_util_CheckPattern(pattern.c_str(), str.c_str()));
}

inline bool TrimLeft(std::string &str, const char *chars)
{
	return ::animone_internal_util_TrimLeft(str.data(), chars);
}

inline bool TrimRight(std::string &str, const char* chars)
{
	return ::animone_internal_util_TrimRight(str.data(), chars);
}

inline intmax_t StringToInt(const std::string &ptr, intmax_t def)
{
	return ::animone_internal_util_StringToInt(ptr.c_str(), def);
}

} // namespace util
} // namespace internal
} // namespace animone

#endif

#endif // ANIMONE_ANIMONE_UTIL_H_
