#ifndef ANIMONE_ANIMONE_PLAYER_H_
#define ANIMONE_ANIMONE_PLAYER_H_

#include <string>
#include <vector>
#include <map>

namespace animone {

enum class ExecutablePlatform {
	Posix,   // Posix platforms that aren't OS X
	Win32,   // Windows
	Xnu,     // OS X
	Unknown, // ...
};

enum class WindowPlatform {
	Quartz,  // OS X
	Win32,   // Windows
	X11,     // X11
	Unknown, // ...
};

enum class Strategy {
	WindowTitle,
	OpenFiles,
	UiAutomation // unused
};

enum class PlayerType {
	Default,
	WebBrowser // unused
};

struct Player {
	PlayerType type = PlayerType::Default;
	std::string name;
	std::string window_title_format;
	std::map<WindowPlatform, std::vector<std::string>> windows;
	std::map<ExecutablePlatform, std::vector<std::string>> executables;
	std::vector<Strategy> strategies;
};

bool ParsePlayersData(const std::string& data, std::vector<Player>& players);
bool ParsePlayersFile(const std::string& path, std::vector<Player>& players);

} // namespace animone

#endif // ANIMONE_ANIMONE_PLAYER_H_