#ifndef ANIMONE_ANIMONE_STRATEGIES_H_
#define ANIMONE_ANIMONE_STRATEGIES_H_

#include "animone.h"

#ifdef __cplusplus
extern "C" {
#endif

int animone_internal_ApplyStrategies(animone::Result *results, size_t results_size);

#ifdef __cplusplus
}

#include <cstdlib>
#include <vector>

namespace animone::internal {

inline bool ApplyStrategies(std::vector<Result>& results)
{
	Result *results_c;
	size_t results_size_c;

	int x = ::animone_internal_ApplyStrategies(results_c, results_size_c);

	results.assign(results_c, results_c + results_size_c);

	std::free(results_c);

	return x;
}

}

#endif // defined(__cplusplus)

#endif // ANIMONE_ANIMONE_STRATEGIES_H_