#ifndef __edl__internal__datatypes_h
#define __edl__internal__datatypes_h

#include <stddef.h>
#include "edl.h" /* EDL_media_type_t */

size_t EDL_internal_parse_int(const char* input, size_t offset, size_t length, int* int_return);
size_t EDL_internal_parse_double(const char* input, size_t offset, size_t length, double* double_return);
size_t EDL_internal_parse_bool(const char* input, size_t offset, size_t length, bool* bool_return);
size_t EDL_internal_parse_media_type(const char* input, size_t offset, size_t length, EDL_media_type_t* media_return);
size_t EDL_internal_parse_string(const char* input, size_t offset, size_t length, char** string_return);

char* EDL_internal_integer_to_string(int value);
char* EDL_internal_double_to_string(double value);
char* EDL_internal_bool_to_string(bool value);
char* EDL_internal_media_type_to_string(EDL_media_type_t value);

#endif /* __edl__internal__datatypes_h */
