#ifndef __edl__edl_h
#define __edl__edl_h

#ifdef __cplusplus
extern "C" {
#endif

#include <stdbool.h> /* C99 required */
#include <stddef.h>

typedef enum {
	MEDIATYPE_VIDEO,
	MEDIATYPE_AUDIO
} MediaType;

typedef struct {
	int id;
	int track;
	double start_time;
	double length;
	double play_rate;
	bool locked;
	bool normalized;
	int stretch_method;
	bool looped;
	bool on_ruler;
	MediaType media_type;
	char* filename;
	int stream;
	double stream_start;
	double stream_length;
	double fade_time_in;
	double fade_time_out;
	double sustain_gain;
	int curve_in;
	double gain_in;
	int curve_out;
	double gain_out;
	int layer;
	int color;
	int curve_in_r;
	int curve_out_r;
	double play_pitch;
	bool lock_pitch;
	int first_channel;
	int channels;
} EDL_line;

typedef struct {
	EDL_line* arr;
	int capacity;
	int size;
} EDL_file;

EDL_file EDL_parse(const char* text, size_t length);
void EDL_free(EDL_file file);

#ifdef __cplusplus
}
#endif

#endif
