#ifndef EDL_INTERNAL_DATATYPES_H_
#define EDL_INTERNAL_DATATYPES_H_

#include <stddef.h>
#include "edl.h" /* EDL_media_type_t */
#include "str.h"

size_t EDL_internal_parse_int(const char* input, size_t offset, size_t length, int* int_return);
size_t EDL_internal_parse_double(const char* input, size_t offset, size_t length, double* double_return);
size_t EDL_internal_parse_bool(const char* input, size_t offset, size_t length, bool* bool_return);
size_t EDL_internal_parse_media_type(const char* input, size_t offset, size_t length, EDL_media_type_t* media_return);
size_t EDL_internal_parse_string(const char* input, size_t offset, size_t length, char** string_return);

int EDL_internal_append_integer_to_string(EDL_internal_string* str, int value);
int EDL_internal_append_double_to_string(EDL_internal_string* str, double value);
int EDL_internal_append_bool_to_string(EDL_internal_string* str, bool value);
int EDL_internal_append_media_type_to_string(EDL_internal_string* str, EDL_media_type_t value);

#endif /* EDL_INTERNAL_DATATYPES_H_ */
