#ifndef __gui__pages__torrents_h
#define __gui__pages__torrents_h

#include "core/torrent.h"
#include <QAbstractListModel>
#include <QFrame>
#include <QItemSelection>
#include <QSortFilterProxyModel>

class QTreeView;

class TorrentsPageListSortFilter final : public QSortFilterProxyModel {
	Q_OBJECT

public:
	TorrentsPageListSortFilter(QObject* parent = nullptr);

protected:
	bool lessThan(const QModelIndex& l, const QModelIndex& r) const override;
};

class TorrentsPageListModel final : public QAbstractListModel {
	Q_OBJECT

public:
	enum columns {
		TL_TITLE,
		TL_EPISODE,
		TL_GROUP,
		TL_SIZE,
		TL_RESOLUTION,
		TL_SEEDERS,
		TL_LEECHERS,
		TL_DOWNLOADS,
		TL_DESCRIPTION,
		TL_FILENAME,
		TL_RELEASEDATE,

		NB_COLUMNS
	};

	TorrentsPageListModel(QObject* parent);
	~TorrentsPageListModel() override = default;
	int rowCount(const QModelIndex& parent = QModelIndex()) const override;
	int columnCount(const QModelIndex& parent = QModelIndex()) const override;
	bool setData(const QModelIndex& index, const QVariant& value, int role) override;
	QVariant data(const QModelIndex& index, int role) const override;
	QVariant headerData(const int section, const Qt::Orientation orientation, const int role) const override;
	Qt::ItemFlags flags(const QModelIndex& index) const override;

	QByteArray DownloadTorrentList();
	void DownloadTorrents(QItemSelection selection);
	void ParseFeedDescription(const std::string& description, Torrent& torrent);
	void ParseTorrentList(const QByteArray& ba);
	void RefreshTorrentList();

private:
	class TorrentModelItem : public Torrent {
	public:
		bool GetChecked() const { return _checked; };
		void SetChecked(bool checked) { _checked = checked; };

	private:
		bool _checked = false;
	};

	std::vector<TorrentModelItem> list;
};

class TorrentsPage final : public QFrame {
	Q_OBJECT

public:
	TorrentsPage(QWidget* parent = nullptr);
	void DownloadSelection();
	void Refresh();

private:
	TorrentsPageListModel* model = nullptr;
	TorrentsPageListSortFilter* sort_model = nullptr;
	QTreeView* treeview = nullptr;
};

#endif // __gui__pages__torrents_h
