#ifndef __gui__sidebar_h
#define __gui__sidebar_h

#include <QItemSelectionModel>
#include <QListWidget>

class QListWidgetItem;

class SideBar final : public QListWidget {
	Q_OBJECT

public:
	SideBar(QWidget* parent = nullptr);
	QListWidgetItem* AddItem(QString name, QIcon icon = QIcon());
	QListWidgetItem* AddSeparator();
	int GetCurrentItem();
	bool IndexIsSeparator(QModelIndex index) const;
	static QIcon CreateIcon(const char* file);
	void SetBackgroundColor(QColor color);

signals:
	void CurrentItemChanged(int index);

public slots:
	void SetCurrentItem(int index);

protected:
	virtual void mouseMoveEvent(QMouseEvent* event) override;
	QItemSelectionModel::SelectionFlags selectionCommand(const QModelIndex& index, const QEvent* event) const override;
	int RemoveSeparatorsFromIndex(int index);
	int AddSeparatorsToIndex(int index);
};

#endif // __gui__sidebar_h
