#ifndef ANIMONE_ANIMONE_H_
#define ANIMONE_ANIMONE_H_

#include <cstdint>

#include "animone/media.h"
#include "animone/player.h"
#include "animone/types.h"

namespace animone {

struct Process {
	internal::pid_t pid = 0; /* platform-dependent PID */
	ExecutablePlatform platform = ExecutablePlatform::Unknown; /* platform of the executable */
	std::string comm; /* the full filename of the executable */
};

struct Window {
	std::uint32_t id = 0; /* platform-dependent window id */
	WindowPlatform platform = WindowPlatform::Unknown; /* platform of the window */
	std::string class_name; /* class name on win32 and x11, bundle ID on macos */
	std::string text; /* title bar text if available */
};

struct Result {
	Player player;
	Process process;
	Window window; /* has nothing under process mode */
	std::vector<Media> media;
};

bool GetResults(const std::vector<Player>& players, std::vector<Result>& results);

} // namespace animone

#endif // ANIMONE_ANIMONE_H_
