#ifndef ANIMONE_ANIMONE_UTIL_WIN32_H_
#define ANIMONE_ANIMONE_UTIL_WIN32_H_

#include <windef.h>
#include <subauth.h>
#include <handleapi.h>

#include <memory>
#include <string>

namespace animone::internal::win32 {

struct HandleDeconstructor {
	using pointer = HANDLE;
	void operator()(pointer t) const { ::CloseHandle(t); };
};

using Handle = std::unique_ptr<HANDLE, HandleDeconstructor>;

/* ----------------------------------------------- */

std::string ToUtf8String(const std::wstring& string);
std::string ToUtf8String(const UNICODE_STRING& string);
std::wstring ToWstring(const std::string& string);

/* XXX can this stuff be moved to fd/win32.cc? */
bool IsSystemDirectory(const std::string& path);
bool IsSystemDirectory(std::wstring path);

} // namespace animone::internal::win32

#endif // ANIMONE_ANIMONE_UTIL_WIN32_H_