#include "settings.h"
#include "anilist.h"
#include "session.h"
#include <QGroupBox>
#include <QComboBox>
#include <QPushButton>
#include <QSizePolicy>

QWidget* SettingsPageServices::CreateMainPage() {
	QWidget* result = new QWidget(this);
	result->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QGroupBox* sync_group_box = new QGroupBox(tr("Synchronization"), result);
	sync_group_box->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QLabel* sync_combo_box_label = new QLabel(tr("Active service and metadata provider:"), sync_group_box);

	QComboBox* sync_combo_box = new QComboBox(sync_group_box);
	sync_combo_box->addItem(tr("AniList"));
	connect(sync_combo_box, QOverload<int>::of(&QComboBox::currentIndexChanged), this, [this](int index){
		service = static_cast<enum AnimeListServices>(index + 1);
	});
	sync_combo_box->setCurrentIndex(service - 1);

	QLabel* sync_note_label = new QLabel(tr("Note: Weeaboo is unable to synchronize multiple services at the same time."), sync_group_box);

	QVBoxLayout* sync_layout = new QVBoxLayout;
	sync_layout->addWidget(sync_combo_box_label);
	sync_layout->addWidget(sync_combo_box);
	sync_layout->addWidget(sync_note_label);
	sync_group_box->setLayout(sync_layout);

	QVBoxLayout* full_layout = new QVBoxLayout;
	full_layout->addWidget(sync_group_box);
	full_layout->addStretch();
	result->setLayout(full_layout);
	return result;
}

QWidget* SettingsPageServices::CreateAniListPage() {
	QWidget* result = new QWidget(this);
	result->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);

	QGroupBox* group_box = new QGroupBox(tr("Account"), result);
	group_box->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QLabel* username_entry_label = new QLabel(tr("Username: (not your email address)"), group_box);

	QWidget* auth_widget = new QWidget(group_box);
	QLineEdit* username_entry = new QLineEdit(username, auth_widget);
	connect(username_entry, &QLineEdit::editingFinished, this, [this, username_entry]{
		username = username_entry->text();
	});

	QPushButton* auth_button = new QPushButton(auth_widget);
	connect(auth_button, &QPushButton::clicked, this, []{
		AniList a;
		a.Authorize();
	});
	auth_button->setText(session.config.anilist.auth_token.empty() ? tr("Authorize...") : tr("Re-authorize..."));

	QHBoxLayout* auth_layout = new QHBoxLayout;
	auth_layout->addWidget(username_entry);
	auth_layout->addWidget(auth_button);
	auth_widget->setLayout(auth_layout);

	QLabel* note_label = new QLabel(tr("<a href=\"http://anilist.co/\">Create a new AniList account</a>"), group_box);
	note_label->setTextFormat(Qt::RichText);
	note_label->setTextInteractionFlags(Qt::TextBrowserInteraction);
	note_label->setOpenExternalLinks(true);

	QVBoxLayout* layout = new QVBoxLayout;
	layout->addWidget(username_entry_label);
	layout->addWidget(auth_widget);
	layout->addWidget(note_label);
	group_box->setLayout(layout);

	QVBoxLayout* full_layout = new QVBoxLayout;
	full_layout->addWidget(group_box);
	full_layout->addStretch();
	result->setLayout(full_layout);
	return result;
}

void SettingsPageServices::SaveInfo() {
	session.config.anilist.username = username.toStdString();
	session.config.service = service;
}

SettingsPageServices::SettingsPageServices(QWidget* parent)
	: SettingsPage(parent, tr("Services")) {
	username = QString::fromUtf8(session.config.anilist.username.c_str());
	service = session.config.service;
	AddTab(CreateMainPage(), tr("Main"));
	AddTab(CreateAniListPage(), tr("AniList"));
}
