#include <QPlainTextEdit>
#include <QVBoxLayout>
#include <QTextStream>
#include <QDebug>
#include "window.h"
#include "anime.h"
#include "anime_list.h"
#include "information.h"
#include "ui_utils.h"
#include "string_utils.h"

#include <QDialogButtonBox>

void InformationDialog::OnOK() {
	model->UpdateAnime(*anime);
	QDialog::accept();
}

InformationDialog::InformationDialog(Anime& a, AnimeListWidgetModel* model, QWidget* parent)
                                   : QDialog(parent)
                                     {
	this->model = model;
	this->anime = &a;
	setFixedSize(842, 613);
	setWindowTitle(tr("Anime Information"));
	setWindowFlags(Qt::Dialog | Qt::CustomizeWindowHint | Qt::WindowTitleHint | Qt::WindowCloseButtonHint);
	setObjectName("infodiag");
	QWidget* widget = new QWidget(this);
	widget->resize(842-175, 530);
	widget->move(175, 0);
	widget->setStyleSheet(UiUtils::IsInDarkMode() ? "" : "background-color: white");
	widget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
	QPlainTextEdit* anime_title = new QPlainTextEdit(QString::fromUtf8(anime->GetUserPreferredTitle().c_str()), widget);
	anime_title->setReadOnly(true);
	anime_title->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	anime_title->setWordWrapMode(QTextOption::NoWrap);
	anime_title->setFrameShape(QFrame::NoFrame);
	anime_title->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
	anime_title->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	anime_title->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	anime_title->setStyleSheet("font-size: 16px; color: blue; background: transparent;");
	anime_title->resize(636, 28);
	anime_title->move(0, 12);
	QTabWidget* tabbed_widget = new QTabWidget(widget);
	tabbed_widget->resize(636, 485);
	tabbed_widget->move(0, 45);
	tabbed_widget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
	QWidget* main_information_widget = new QWidget(tabbed_widget);
	main_information_widget->setLayout(new QVBoxLayout);

	QString alternative_titles = QString::fromUtf8(StringUtils::Implode(anime->GetTitleSynonyms(), ", ").c_str());

	QWidget* alternative_titles_w = UiUtils::CreateSelectableTextParagraph(main_information_widget, "Alternative titles", alternative_titles)->parentWidget()->parentWidget();
	//alternative_titles_w->setFixedHeight(60);
	main_information_widget->layout()->addWidget(alternative_titles_w);

	QString details_data("");
	QTextStream details_data_s(&details_data);
	details_data_s << AnimeFormatToStringMap[anime->type].c_str() << "\n"
	               << anime->episodes << "\n"
	               << AnimeAiringToStringMap[anime->airing].c_str() << "\n"
	               << AnimeSeasonToStringMap[anime->season].c_str() << " " << anime->air_date.GetYear() << "\n"
	               << StringUtils::Implode(anime->genres, ", ").c_str() << "\n"
	               << anime->audience_score << "%\n";
	QWidget* soidjhfh = UiUtils::CreateTextParagraphWithLabels(main_information_widget, "Details", "Type:\nEpisodes:\nStatus:\nSeason:\nGenres:\nScore:", details_data)->parentWidget()->parentWidget();
	main_information_widget->layout()->addWidget(soidjhfh);

	QPlainTextEdit* synopsis = UiUtils::CreateSelectableTextParagraph(main_information_widget, "Synopsis", QString::fromUtf8(anime->synopsis.c_str()));
	synopsis->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
	synopsis->parentWidget()->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
	synopsis->parentWidget()->parentWidget()->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
	((QVBoxLayout*)main_information_widget->layout())->addWidget(synopsis->parentWidget()->parentWidget());

	//((QVBoxLayout*)main_information_widget->layout())->addStretch();

	tabbed_widget->addTab(main_information_widget, "Main information");
	QWidget* settings_widget = new QWidget(tabbed_widget);
	tabbed_widget->addTab(settings_widget, "My list and settings");
	QDialogButtonBox* button_box = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel, this);
	connect(button_box, &QDialogButtonBox::accepted, this, &InformationDialog::OnOK);
	connect(button_box, &QDialogButtonBox::rejected, this, &QDialog::reject);
	QVBoxLayout* buttons_layout = new QVBoxLayout(this);
	//buttons_layout->addWidget(widget, 0, Qt::AlignTop);
	buttons_layout->addWidget(button_box, 0, Qt::AlignBottom);
	// this should probably be win32-only
	setStyleSheet(UiUtils::IsInDarkMode() ? "" : "QDialog#infodiag{background-color: white;}");
	setLayout(buttons_layout);
}

#include "moc_information.cpp"
