#ifndef __config_h
#define __config_h
enum AnimeTitleLanguage {
	ROMAJI,
	NATIVE,
	ENGLISH
};

enum AnimeListServices {
	NONE,
	ANILIST,
	NB_SERVICES
};

enum Themes {
	LIGHT,
	DARK,
	OS
};

class Config {
	public:
		int Load();
		int Save();

		enum AnimeListServices service;
		enum Themes theme;

		struct {
			enum AnimeTitleLanguage language;
			bool display_aired_episodes;
			bool display_available_episodes;
			bool highlight_anime_if_available;
			bool highlighted_anime_above_others;
		} anime_list;

		struct {
			std::string auth_token;
			std::string username;
			int user_id;
		} anilist;
};
#define CONFIG_DIR  "weeaboo"
#define CONFIG_NAME "config.json"
#define MAX_LINE_LENGTH 256
#endif // __config_h
