#ifndef __anilist_h
#define __anilist_h
#include <curl/curl.h>
#include "anime.h"
#include "json.h"
class AniList {
	public:
		static int Authorize();
		static int GetUserId(std::string name);
		static int UpdateAnimeList(std::vector<AnimeList>* anime_lists, int id);

	private:
		static size_t CurlWriteCallback(void *contents, size_t size, size_t nmemb, void *userdata);
		static std::string SendRequest(std::string data);
		static enum AnimeWatchingStatus ConvertWatchingStatusToEnum(std::string status);
		static enum AnimeAiringStatus ConvertAiringStatusToEnum(std::string status);
		static enum AnimeFormat ConvertFormatToEnum(std::string format);
		static enum AnimeSeason ConvertSeasonToEnum(std::string season);
		static CURL* curl;
		static CURLcode res;
};
#endif // __anilist_h
