#ifndef __settings_h
#define __settings_h
#include <QWidget>
#include <QDialog>
#include <QTabWidget>
#include <QLabel>
#include <QLineEdit>
#include <QComboBox>
#include <QHBoxLayout>
#include "sidebar.h"
#include "anime.h"
class SettingsPage : public QWidget {
	Q_OBJECT

	public:
		SettingsPage(QWidget* parent = nullptr, QString title = "");
		void SetTitle(QString title);
		virtual void SaveInfo();
		void AddTab(QWidget* tab, QString title = "");

	private:
		QLabel* page_title;
		QTabWidget* tab_widget;
};

class SettingsPageServices : public SettingsPage {
	public:
		SettingsPageServices(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateMainPage();
		QWidget* CreateAniListPage();
		QString username;
		enum AnimeListServices service;
};

class SettingsPageApplication : public SettingsPage {
	public:
		SettingsPageApplication(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateAnimeListWidget();
		enum AnimeTitleLanguage language;
		bool display_aired_episodes;
		bool display_available_episodes;
		bool highlight_anime_if_available;
		bool highlighted_anime_above_others;
};

class SettingsDialog : public QDialog {
	Q_OBJECT

	public:
		SettingsDialog(QWidget* parent = nullptr);
		QWidget* CreateServicesMainPage(QWidget* parent);
		void OnOK();

	private:
		QHBoxLayout* layout;
		SideBar* sidebar;
};
#endif // __settings_h