#ifndef __ui_utils_h
#define __ui_utils_h
#include <QWidget>
#include <QString>
#include <QPoint>
#include <QSize>
#include <QDateTime>
#include <QIcon>
#include <QPlainTextEdit>
namespace UiUtils {
	QIcon CreateSideBarIcon(const char* file);
	bool IsInDarkMode();
	std::string GetLengthFromQDateTime(QDateTime stamp);
	QPlainTextEdit* CreateTextParagraph(QWidget* parent, QString title, QString data);
	QPlainTextEdit* CreateTextParagraphWithLabels(QWidget* parent, QString title, QString label, QString data);
	QPlainTextEdit* CreateSelectableTextParagraph(QWidget* parent, QString title, QString data);
	void SetPlainTextEditData(QPlainTextEdit* text_edit, QString data);
	void CreateTextHeader(QWidget* parent, QString title);
};

class Paragraph : public QPlainTextEdit {
	public:
		Paragraph(QString text, QWidget* parent = nullptr);
		QSize minimumSizeHint() const override;
		QSize sizeHint() const override;
};
#endif // __ui_utils_h