#include <sstream>
#include <QWidget>
#include <QTimer>
#include <QTextStream>
#include <QString>
#include <QTextDocument>
#include <QVBoxLayout>
#include "anime_list.h"
#include "ui_utils.h"
#include "statistics.h"

StatisticsWidget::StatisticsWidget(AnimeListWidget* listwidget, QWidget* parent)
	: QFrame(parent) {
	setLayout(new QVBoxLayout);
	anime_list = listwidget;

	setFrameShape(QFrame::Panel);
	setFrameShadow(QFrame::Plain);

	layout()->addWidget((anime_list_data = UiUtils::CreateTextParagraphWithLabels(this, "Anime list", "Anime count:\nEpisode count:\nTime spent watching:\nTime to complete:\nAverage score:\nScore deviation:", ""))->parentWidget()->parentWidget());
	((QBoxLayout*)layout())->addStretch();

	QPalette pal = QPalette();
	pal.setColor(QPalette::Window, Qt::white);
	setAutoFillBackground(true); 
	setPalette(pal);

	UpdateStatistics(); // load in statistics as soon as possible

	QTimer* timer = new QTimer(this);
	connect(timer, &QTimer::timeout, this, [this]{
		if (isVisible())
			UpdateStatistics();
	});
	timer->start(1000); // update statistics every second
}

std::string StatisticsWidget::MinutesToDateString(int minutes) {
	/* NOTE: these duration_casts may not be needed... */
	std::chrono::duration<int, std::ratio<60>> int_total_mins(minutes);
	auto int_years = std::chrono::duration_cast<std::chrono::years>(int_total_mins);
	auto int_months = std::chrono::duration_cast<std::chrono::months>(int_total_mins-int_years);
	auto int_days = std::chrono::duration_cast<std::chrono::days>(int_total_mins-int_years-int_months);
	auto int_hours = std::chrono::duration_cast<std::chrono::hours>(int_total_mins-int_years-int_months-int_days);
	auto int_minutes = std::chrono::duration_cast<std::chrono::minutes>(int_total_mins-int_years-int_months-int_days-int_hours);
	std::ostringstream return_stream;
	if (int_years.count() > 0) {
		return_stream << int_years.count() << " years ";
	}
	if (int_months.count() > 0) {
		return_stream << int_months.count() << " months ";
	}
	if (int_days.count() > 0) {
		return_stream << int_days.count() << " days ";
	}
	if (int_hours.count() > 0) {
		return_stream << int_hours.count() << " hours ";
	}
	return_stream << int_minutes.count() << " minutes"; // return minutes anyway
	return return_stream.str();
}

void StatisticsWidget::UpdateStatistics() {
	QString string = "";
	QTextStream ts(&string);
	ts << anime_list->GetTotalAnimeAmount() << '\n';
	ts << anime_list->GetTotalEpisodeAmount() << '\n';
	ts << MinutesToDateString(anime_list->GetTotalWatchedAmount()).c_str() << '\n';
	ts << MinutesToDateString(anime_list->GetTotalPlannedAmount()).c_str() << '\n';
	ts << anime_list->GetAverageScore() << '\n';
	ts << anime_list->GetScoreDeviation() << '\n';
	UiUtils::SetPlainTextEditData(anime_list_data, string);
}
