#ifndef __animia__animia__media_h
#define __animia__animia__media_h

#include <chrono>
#include <functional>
#include <string>
#include <vector>

namespace animia {

using media_time_t = std::chrono::milliseconds;

enum class MediaInfoType {
	Unknown,
	File,
	Tab,
	Title,
	Url
};

struct MediaInfo {
		MediaInfoType type = MediaInfoType::Unknown;
		std::string value;
};

struct Media {
		std::vector<MediaInfo> information;
};

} // namespace animia

#endif // __animia__animia__media_h
