#ifndef MINORI_GUI_PAGES_SEASONS_H_
#define MINORI_GUI_PAGES_SEASONS_H_

#include <QFrame>
#include <QThread>

#include "core/anime.h"
#include "core/date.h"

#include <utility>
#include <queue>

class QListWidget;
class QToolButton;

Q_DECLARE_METATYPE(Anime::SeriesSeason);
Q_DECLARE_METATYPE(Date::Year);

class SeasonsPageSearchThread : public QThread {
	Q_OBJECT

public:
	SeasonsPageSearchThread(QObject* parent = nullptr);
	void AddToQueue(Anime::SeriesSeason season, Date::Year year);

protected:
	void run() override;

private:
	struct Season {
		Anime::SeriesSeason season;
		Date::Year year;
	};

	std::queue<Season> queue_;
	std::mutex queue_mutex_;

signals:
	void ReceivedSeason(Anime::SeriesSeason season, Date::Year year);
};

class SeasonsPage final : public QFrame {
	Q_OBJECT

public:
	SeasonsPage(QWidget* parent = nullptr);
	void SetSeason(Anime::SeriesSeason season, Date::Year year);
	void Refresh();

protected:
	QListWidget* buttons = nullptr;
	QToolButton* season_button = nullptr;

	Anime::SeriesSeason season_;
	Date::Year year_;
};

#endif // MINORI_GUI_PAGES_SEASONS_H_
