#include "gui/pages/statistics.h"
#include "core/anime_db.h"
#include "core/session.h"
#include "gui/pages/anime_list.h"
#include "gui/widgets/text.h"
#include <QString>
#include <QTextDocument>
#include <QTextStream>
#include <QTimer>
#include <QVBoxLayout>
#include <QWidget>
#include <sstream>

StatisticsWidget::StatisticsWidget(QWidget* parent) : QFrame(parent) {
	setLayout(new QVBoxLayout);

	setFrameShape(QFrame::Panel);
	setFrameShadow(QFrame::Sunken);

	QPalette pal = QPalette();
	pal.setColor(QPalette::Window, pal.color(QPalette::Base));
	setPalette(pal);
	setAutoFillBackground(true);

	TextWidgets::LabelledTextParagraph* anime_list_paragraph = new TextWidgets::LabelledTextParagraph(
	    "Anime list",
	    "Anime count:\nEpisode count:\nTime spent watching:\nTime to complete:\nAverage score:\nScore deviation:", "\n\n\n\n\n\n",
	    this);
	anime_list_data = anime_list_paragraph->GetParagraph();

	TextWidgets::LabelledTextParagraph* application_paragraph =
	    new TextWidgets::LabelledTextParagraph("Minori", "Uptime:\nRequests made:", "\n\n", this);
	application_data = application_paragraph->GetParagraph();

	layout()->addWidget(anime_list_paragraph);
	layout()->addWidget(application_paragraph);
	((QBoxLayout*)layout())->addStretch();

	QTimer* timer = new QTimer(this);
	connect(timer, &QTimer::timeout, this, [this] {
		if (isVisible())
			UpdateStatistics();
	});
	timer->start(1000); // update statistics every second
}

void StatisticsWidget::showEvent(QShowEvent*) {
	UpdateStatistics();
}

/* me abusing macros :) */
#define ADD_TIME_SEGMENT(r, x, s, p) \
	{ \
		if (x > 0) \
			r << x << ((x == 1) ? s : p); \
	}
std::string StatisticsWidget::MinutesToDateString(int minutes) {
	/* ew */
	int years = (minutes * (1 / 525949.2F));
	int months = (minutes * (1 / 43829.1F)) - (years * 12);
	int days = (minutes * (1 / 1440.0F)) - (years * 365.2425F) - (months * 30.436875F);
	int hours = (minutes * (1 / 60.0F)) - (years * 8765.82F) - (months * 730.485F) - (days * 24);
	int rest_minutes = (minutes) - (years * 525949.2F) - (months * 43829.1F) - (days * 1440) - (hours * 60);
	std::ostringstream return_stream;
	ADD_TIME_SEGMENT(return_stream, years, " year ", " years ");
	ADD_TIME_SEGMENT(return_stream, months, " month ", " months ");
	ADD_TIME_SEGMENT(return_stream, days, " day ", " days ");
	ADD_TIME_SEGMENT(return_stream, hours, " hour ", " hours ");
	if (rest_minutes > 0 || return_stream.str().size() == 0)
		return_stream << rest_minutes << ((rest_minutes == 1) ? " minute" : " minutes");
	return return_stream.str();
}

std::string StatisticsWidget::SecondsToDateString(int sec) {
	/* this is all fairly unnecessary, but works:tm: */
	int years = sec * (1 / 31556952.0F);
	int months = sec * (1 / 2629746.0F) - (years * 12);
	int days = sec * (1 / 86400.0F) - (years * 365.2425F) - (months * 30.436875F);
	int hours = sec * (1 / 3600.0F) - (years * 8765.82F) - (months * 730.485F) - (days * 24);
	int minutes = (sec) * (1 / 60.0F) - (years * 525949.2F) - (months * 43829.1F) - (days * 1440.0F) - (hours * 60.0F);
	int seconds =
	    sec - (years * 31556952.0F) - (months * 2629746.0F) - (days * 86400.0F) - (hours * 3600.0F) - (minutes * 60.0F);
	std::ostringstream return_stream;
	ADD_TIME_SEGMENT(return_stream, years, " year ", " years ");
	ADD_TIME_SEGMENT(return_stream, months, " month ", " months ");
	ADD_TIME_SEGMENT(return_stream, days, " day ", " days ");
	ADD_TIME_SEGMENT(return_stream, hours, " hour ", " hours ");
	ADD_TIME_SEGMENT(return_stream, minutes, " minute ", " minutes ");
	if (seconds > 0 || return_stream.str().size() == 0)
		return_stream << seconds << ((seconds == 1) ? " second" : " seconds");
	return return_stream.str();
}
#undef ADD_TIME_SEGMENT

void StatisticsWidget::UpdateStatistics() {
	/* Anime list */
	QString string = "";
	QTextStream ts(&string);
	ts << Anime::db.GetTotalAnimeAmount() << '\n';
	ts << Anime::db.GetTotalEpisodeAmount() << '\n';
	ts << MinutesToDateString(Anime::db.GetTotalWatchedAmount()).c_str() << '\n';
	ts << MinutesToDateString(Anime::db.GetTotalPlannedAmount()).c_str() << '\n';
	ts << Anime::db.GetAverageScore() << '\n';
	ts << Anime::db.GetScoreDeviation();
	TextWidgets::SetPlainTextEditData(anime_list_data, string);

	string = "";
	ts << QString::fromUtf8(SecondsToDateString(session.uptime() / 1000).c_str()) << '\n';
	ts << session.GetRequests();
	/* Application */
	// UiUtils::SetPlainTextEditData(application_data, QString::number(session.uptime() / 1000));
	TextWidgets::SetPlainTextEditData(application_data, string);
}

#include "gui/pages/moc_statistics.cpp"
