#ifndef MINORI_WINDOW_H_
#define MINORI_WINDOW_H_

#include "core/config.h"
#include "gui/widgets/sidebar.h"

/* pages; these should really be in a namespace */
#include "gui/pages/anime_list.h"
#include "gui/pages/history.h"
#include "gui/pages/now_playing.h"
#include "gui/pages/search.h"
#include "gui/pages/seasons.h"
#include "gui/pages/statistics.h"
#include "gui/pages/torrents.h"

#include <QMainWindow>
#include <QCloseEvent>
#include <QStackedWidget>
#include <QThread>
#include <QTimer>
#include <QWidget>

#include <memory>

class QMenu;
class AnimeListPage;

/* ... :) */
Q_DECLARE_METATYPE(std::vector<std::string>);

class MainWindowPlayingThread final : public QThread {
	Q_OBJECT

public:
	MainWindowPlayingThread(QObject* object = nullptr) : QThread(object) {}

protected:
	void run() override;

signals:
	void Done(const std::vector<std::string>& files);
};

class MainWindowAsyncSynchronizeThread final : public QThread {
	Q_OBJECT

public:
	MainWindowAsyncSynchronizeThread(QAction* action, AnimeListPage* page, QObject* object = nullptr);
	void SetAction(QAction* action);
	void SetPage(AnimeListPage* page);

protected:
	void run() override;

private:
	QAction* action_ = nullptr;
	AnimeListPage* page_ = nullptr;
};

class MainWindow final : public QMainWindow {
	Q_OBJECT

public:
	enum class Pages {
		NOW_PLAYING,

		ANIME_LIST,
		HISTORY,
		STATISTICS,

		SEARCH,
		SEASONS,
		TORRENTS
	};

	MainWindow(QWidget* parent = nullptr);
	void SetActivePage(QWidget* page);
	void CreateBars();
	void AddMainWidgets();
	void RetranslateUI();
	void UpdateFolderMenu();
	void AsyncSynchronize(QAction* action, QStackedWidget* stack);
	void changeEvent(QEvent* event) override;
	void showEvent(QShowEvent* event) override;
	void closeEvent(QCloseEvent* event) override;

private:
	QWidget main_widget_;
	QStackedWidget stack_;
	SideBar sidebar_;

	AnimeListPage anime_list_page_;
	HistoryPage history_page_;
	NowPlayingPage now_playing_page_;
	SearchPage search_page_;
	SeasonsPage seasons_page_;
	StatisticsPage statistics_page_;
	TorrentsPage torrents_page_;

	MainWindowPlayingThread playing_thread_;
	QTimer playing_thread_timer_;

	MainWindowAsyncSynchronizeThread async_synchronize_thread_;

	QMenu* folder_menu = nullptr;
};

#endif // MINORI_WINDOW_H_
