#ifndef __core__anime_db_h
#define __core__anime_db_h

#include "core/anime.h"
#include "json/json_fwd.hpp"
#include <string>
#include <unordered_map>

namespace Anime {

class Database {
	public:
		std::unordered_map<int, Anime> items;
		int GetTotalAnimeAmount();
		int GetTotalEpisodeAmount();
		int GetTotalWatchedAmount();
		int GetTotalPlannedAmount();
		double GetAverageScore();
		double GetScoreDeviation();
		int GetListsAnimeAmount(ListStatus status);
		int GetAnimeFromTitle(const std::string& title);

		bool GetDatabaseAsJSON(nlohmann::json& json);
		bool SaveDatabaseToDisk();

		bool ParseDatabaseJSON(const nlohmann::json& json);
		bool LoadDatabaseFromFile();

	protected:
		bool ParseAnimeInfoJSON(const nlohmann::json& json);
};

extern Database db;

} // namespace Anime


#endif // __core__anime_db_h
