#ifndef __animia__animia_h
#define __animia__animia_h

#include "animia/media.h"
#include "animia/player.h"
#include "animia/types.h"

namespace animia {

/* pid_t should be DWORD on windows, and defined by the system
   anywhere else */
struct Process {
	internal::pid_t pid = 0;
	std::string name;
};

struct Window {
	unsigned int id = 0;
	std::string class_name;
	std::string text; // title bar text
};

struct Result {
	Player player;
	Process process;
	//Window window;
	std::vector<Media> media;
};

bool GetResults(const std::vector<Player>& players, std::vector<Result>& results);

} // namespace Animia

#endif // __animia__animia_h
