#ifndef __core__session_h
#define __core__session_h

#include "core/config.h"
#include "track/types.h"
#include "gui/locale.h"
#include <QElapsedTimer>

struct Session {
	public:
		Session() { timer.start(); }
		/* we literally *cannot* be lying to the user by doing this */
		void IncrementRequests() { requests++; };
		int GetRequests() { return requests; };
		int uptime() { return timer.elapsed(); }

		Config config;

		struct {
			std::vector<Track::Types::MediaPlayer> players;
			std::vector<Track::Types::MediaExtension> extensions;
		} recognition;

	private:
		uint32_t requests = 0;
		QElapsedTimer timer;
};

extern Session session;

#endif // __core__session_h
