#include "window.h"
#include "anime.h"
#include "information.h"
#include "ui_utils.h"
#include "string_utils.h"

InformationDialog::InformationDialog(wxWindow* parent, wxWindowID id, const wxString& title, const Anime& anime,
                                     const wxPoint& position, long style)
									 : wxDialog(parent, id, title, position, wxSize(840, 613), style) {
	wxFont font;
	this->SetBackgroundColour(*wxWHITE);
	wxPanel* left_panel = new wxPanel(this, wxID_ANY, wxPoint(0, 12), wxSize(170, 518));
	wxPanel* right_panel = new wxPanel(this, wxID_ANY, wxPoint(170, 12), wxSize(840-186, 518));
	right_panel->SetBackgroundColour(*wxWHITE);
	wxTextCtrl* anime_title = new wxTextCtrl(right_panel, wxID_ANY, anime.title, wxPoint(0, 0), wxSize(840-186, 28), wxTE_LEFT | wxBORDER_NONE | wxTE_BESTWRAP | wxTE_READONLY | wxTE_MULTILINE | wxTE_NO_VSCROLL);
	anime_title->SetForegroundColour(wxTheColourDatabase->Find("STEEL BLUE"));
	font = anime_title->GetFont();
	font.SetPointSize(12);
	anime_title->SetFont(font);
	wxNotebook* notebook = new wxNotebook(right_panel, wxID_ANY, wxPoint(0, 35), wxSize(840-186, 518-35));
	notebook->SetBackgroundColour(*wxWHITE);
	wxPanel* main_information_panel = new wxPanel(notebook, wxID_ANY, wxPoint(6, 6), wxDefaultSize);
	UiUtils::CreateSelectableTextParagraph(main_information_panel, L"Alternative titles", L"-", 840-186-6-6, 15);
	std::wstringstream details_data;
	details_data << AnimeFormatToStringMap[anime.type] << "\n"
	             << anime.episodes << "\n"
	             << AnimeAiringToStringMap[anime.airing] << "\n"
	             << AnimeSeasonToStringMap[anime.season] << " " << int(anime.air_date.year()) << "\n"
	             << StringUtils::Implode(anime.genres, ", ") << "\n"
	             << anime.audience_score << "%\n";
	UiUtils::CreateTextParagraphWithLabels(main_information_panel, L"Details", L"Type:\nEpisodes:\nStatus:\nSeason:\nGenres:\nScore:", details_data.str().c_str(), 840-186-6-6, 94, 0, 50);
	UiUtils::CreateSelectableTextParagraph(main_information_panel, L"Synopsis", anime.synopsis.c_str(), 840-186-6-6, 200, 0, 200);

	wxPanel* data_input_panel = new wxPanel(notebook, wxID_ANY, wxPoint(6, 6), wxDefaultSize);
	
	notebook->AddPage(main_information_panel, "Main information");
	notebook->AddPage(data_input_panel, "Anime list and settings");
	
}
