#ifndef __anilist_h
#define __anilist_h
#include <curl/curl.h>
#include "anime.h"
class AniList {
	public:
		int Authorize();
		int GetUserId(std::string name);
		int UpdateAnimeList(std::vector<AnimeList>* anime_lists, int id);

	private:
		static size_t CurlWriteCallback(void *contents, size_t size, size_t nmemb, void *userdata);
		enum AnimeWatchingStatus ConvertWatchingStatusToEnum(std::string status);
		enum AnimeAiringStatus ConvertAiringStatusToEnum(std::string status);
		enum AnimeFormat ConvertFormatToEnum(std::string format);
		enum AnimeSeason ConvertSeasonToEnum(std::string season);
		std::string SendRequest(std::string data);
		CURL* curl;
		CURLcode res;
};

/* FIXME: at some point, we have to add a separate Date class (which IIRC
   Kitsu actually does as well), because the standard library functions do
   not support any null values. Internally, we could represent null or undefined
   values as... -1?. Also, anything anime-related should probably be in an
   Anime namespace. */
#define ANILIST_DATE_IS_VALID(a) \
	(a["year"].is_number() && a["month"].is_number() && a["day"].is_number())
#define ANILIST_DATE_TO_YMD(a) \
	std::chrono::year_month_day(std::chrono::year(a["year"].get<int>()), \
								std::chrono::month(a["month"].get<int>()), \
								std::chrono::day(a["day"].get<int>()))
#endif // __anilist_h
