#ifndef __string_utils_h
#define __string_utils_h
#include <string>
#include <vector>
namespace StringUtils {
	/* Implode function: takes a vector of strings and turns it
	   into a string, separated by delimiters. */
	std::string  Implode(const std::vector<std::string>& vector,
	                     const std::string& delimiter);
	std::wstring Implode(const std::vector<std::wstring>& vector,
                         const std::wstring& delimiter);

	/* Conversion from UTF-8 to std::wstring and vice versa */
	std::string  WstrToUtf8(const std::wstring& string);
	std::wstring Utf8ToWstr(const std::string& string);

	/* Substring removal functions */
	std::string  ReplaceAll(const std::string& string,
						    const std::string& find,
						    const std::string& replace);
	std::wstring ReplaceAll(const std::wstring& string,
                            const std::wstring& find,
							const std::wstring& replace);
	std::string  SanitizeLineEndings(const std::string& string);
	std::wstring SanitizeLineEndings(const std::wstring& string);
	std::wstring RemoveHtmlTags(const std::wstring& string);
	std::string  RemoveHtmlTags(const std::string& string);

	/* stupid HTML bullshit */
	std::string  TextifySynopsis(const std::string& string);
	std::wstring TextifySynopsis(const std::wstring& string);
};
#endif // __string_utils_h