#ifndef __ui_utils_h
#define __ui_utils_h
namespace UiUtils {
	/* Creates a text paragraph with a title header.
	   Note: the `height` parameters for both of these functions is actually
	   the height of the data on its own.
	   Returns a pointer to the data wxStaticText element. */
	wxStaticText* CreateTextParagraph(wxWindow* parent, const wchar_t* title, const wchar_t* data, int width, int height, int x = 0, int y = 0);

	wxStaticText* CreateTextParagraphWithLabels(wxWindow* parent, const wchar_t* title, const wchar_t* label, const wchar_t* data, int width, int height, int x = 0, int y = 0);
	wxTextCtrl* CreateSelectableTextParagraph(wxWindow* parent, const wchar_t* title, const wchar_t* data, int width, int height, int x = 0, int y = 0);
	void CreateTextHeader(wxWindow* parent, const wchar_t* title, int width, int x = 0, int y = 0);
};
#endif // __ui_utils_h