#ifndef MINORI_CORE_HTTP_H_
#define MINORI_CORE_HTTP_H_

#include <QByteArray>
#include <QThread>

#include <mutex>
#include <string>
#include <vector>

namespace HTTP {

/* calls libcurl to encode/decode */
std::string UrlEncode(const std::string &data);
std::string UrlDecode(const std::string &data);

std::string EncodeParamsList(std::string base, const std::map<std::string, std::string> &params);

enum class Type {
	Get,
	Post
};

QByteArray Request(const std::string &url, const std::vector<std::string> &headers = {}, const std::string &data = "",
                   Type type = Type::Get);

class RequestThread final : public QThread {
	Q_OBJECT

public:
	RequestThread(Type type = Type::Get, QObject *parent = nullptr);
	RequestThread(const std::string &url, const std::vector<std::string> &headers = {}, const std::string &data = "",
	              Type type = Type::Get, QObject *parent = nullptr);
	~RequestThread();

	void SetUrl(const std::string &url);
	void SetHeaders(const std::vector<std::string> &headers);
	void SetData(const std::string &data);
	void SetType(Type type);

	void Stop();

signals:
	void ReceivedData(const QByteArray &ba);

protected:
	void run() override;
	static size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userdata);

	std::string url_;
	std::string data_;
	std::vector<std::string> headers_;
	Type type_;

	/* these are passed to the write callback */
	QByteArray array_;
	bool cancelled_ = false;

	/* don't fuck this up */
	std::mutex callback_data_mutex_;
};

} // namespace HTTP

#endif // MINORI_CORE_HTTP_H_
