#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QPlainTextEdit>
#include <QPlainTextDocumentLayout>
#include <QComboBox>
#include <QGroupBox>
#include <QWidget>
#include <QTextDocument>
#include "settings.h"
#include "sidebar.h"
#include "ui_utils.h"

SettingsPage::SettingsPage(QWidget* parent, QString title)
	: QWidget(parent) {
	setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
	page_title = new QLabel(title, this);
	page_title->setWordWrap(false);
	page_title->setFrameShape(QFrame::Panel);
	page_title->setFrameShadow(QFrame::Sunken);
	page_title->setStyleSheet("QLabel { font-size: 10pt; font-weight: bold; background-color: #ABABAB; color: white; }");
	page_title->setFixedHeight(23);
	page_title->setAlignment(Qt::AlignVCenter | Qt::AlignLeft);
	page_title->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Fixed);
	tab_widget = new QTabWidget(this);
	tab_widget->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);

	QVBoxLayout* layout = new QVBoxLayout;
	layout->setMargin(0);
	layout->addWidget(page_title);
	layout->addWidget(tab_widget);
	setLayout(layout);
}

void SettingsPage::SetTitle(QString title) {
	page_title->setText(title);
}

void SettingsPage::AddTab(QWidget* tab, QString title) {
	tab_widget->addTab(tab, title);
}

void SettingsPage::SaveInfo() {
	// no-op... child classes will implement this
}

void SettingsDialog::OnSidebar(QListWidgetItem* item) {
	layout->itemAt(1)->widget()->setVisible(false); // old widget
	layout->replaceWidget(layout->itemAt(1)->widget(), pages[item->listWidget()->row(item)], Qt::FindDirectChildrenOnly);
	pages[item->listWidget()->row(item)]->setVisible(true); // new widget
}

void SettingsDialog::OnOK() {
	for (const auto& page : pages) {
		page->SaveInfo();
	}
	QDialog::accept();
}

SettingsDialog::SettingsDialog(QWidget* parent)
	: QDialog(parent) {
	setFixedSize(755, 566);
	setWindowTitle(tr("Settings"));
	setWindowFlags(Qt::Dialog | Qt::CustomizeWindowHint | Qt::WindowTitleHint | Qt::WindowCloseButtonHint);
	QWidget* widget = new QWidget(this);
	widget->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
	sidebar = new SideBar(widget);
	sidebar->setCurrentItem(sidebar->AddItem(tr("Services"), UiUtils::CreateSideBarIcon(":/icons/24x24/globe.png")));
	//sidebar->AddItem(tr("Library"), UiUtils::CreateSideBarIcon(":/icons/24x24/inbox-film.png"));
	sidebar->AddItem(tr("Application"), UiUtils::CreateSideBarIcon(":/icons/24x24/application-sidebar-list.png"));
	//sidebar->AddItem(tr("Recognition"), UiUtils::CreateSideBarIcon(":/icons/24x24/question.png"));
	//sidebar->AddItem(tr("Sharing"), UiUtils::CreateSideBarIcon(":/icons/24x24/megaphone.png"));
	//sidebar->AddItem(tr("Torrents"), UiUtils::CreateSideBarIcon(":/icons/24x24/feed.png"));
	//sidebar->AddItem(tr("Advanced"), UiUtils::CreateSideBarIcon(":/icons/24x24/gear.png"));
	sidebar->setIconSize(QSize(24, 24));
	sidebar->setFrameShape(QFrame::Box);
	sidebar->setStyleSheet("QListWidget { background-color: white; font-size: 12px; }");
	sidebar->setFixedWidth(158);
	sidebar->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Expanding);
	connect(sidebar, &QListWidget::itemActivated, this, &SettingsDialog::OnSidebar);
	
	SettingsPageServices* services_page = new SettingsPageServices(this);
	pages.push_back(services_page);
	SettingsPageApplication* application_page = new SettingsPageApplication(this);
	application_page->setVisible(false);
	pages.push_back(application_page);

	layout = new QHBoxLayout;
	layout->addWidget(sidebar);
	layout->addWidget(services_page);
	layout->setMargin(0);
	widget->setLayout(layout);
	
	QDialogButtonBox* button_box = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel, this);
	connect(button_box, &QDialogButtonBox::accepted, this, &SettingsDialog::OnOK);
	connect(button_box, &QDialogButtonBox::rejected, this, &QDialog::reject);

	QVBoxLayout* buttons_layout = new QVBoxLayout(this);
	buttons_layout->addWidget(widget);
	buttons_layout->addWidget(button_box);
	setLayout(buttons_layout);
}

#include "moc_settings.cpp"
