#include "settings.h"
#include "anilist.h"
#include "window.h"
#include <QGroupBox>
#include <QComboBox>
#include <QCheckBox>
#include <QPushButton>
#include <QSizePolicy>

QWidget* SettingsPageApplication::CreateAnimeListPage() {
	QWidget* result = new QWidget(this);
	result->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QGroupBox* actions_group_box = new QGroupBox(tr("Actions"), result);
	actions_group_box->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	/* Actions/Double click */
	QWidget* double_click_widget = new QWidget(actions_group_box);
	QLabel* dc_combo_box_label = new QLabel(tr("Double click:"), double_click_widget);
	QComboBox* dc_combo_box = new QComboBox(double_click_widget);
	dc_combo_box->addItem(tr("View anime info"));

	QVBoxLayout* double_click_layout = new QVBoxLayout;
	double_click_layout->addWidget(dc_combo_box_label);
	double_click_layout->addWidget(dc_combo_box);
	double_click_widget->setLayout(double_click_layout);

	/* Actions/Middle click */
	QWidget* middle_click_widget = new QWidget(actions_group_box);
	QLabel* mc_combo_box_label = new QLabel(tr("Middle click:"), middle_click_widget);
	QComboBox* mc_combo_box = new QComboBox(middle_click_widget);
	mc_combo_box->addItem(tr("Play next episode"));

	QVBoxLayout* middle_click_layout = new QVBoxLayout;
	middle_click_layout->addWidget(mc_combo_box_label);
	middle_click_layout->addWidget(mc_combo_box);
	middle_click_widget->setLayout(middle_click_layout);

	/* Actions */
	QHBoxLayout* actions_layout = new QHBoxLayout;
	actions_layout->addWidget(double_click_widget);
	actions_layout->addWidget(middle_click_widget);
	actions_group_box->setLayout(actions_layout);

	QGroupBox* appearance_group_box = new QGroupBox(tr("Appearance"), result);
	appearance_group_box->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QLabel* lang_combo_box_label = new QLabel(tr("Title language preference:"), appearance_group_box);
	QComboBox* lang_combo_box = new QComboBox(appearance_group_box);
	lang_combo_box->addItem(tr("English"));
	QCheckBox* hl_anime_box = new QCheckBox(tr("Highlight anime if next episode is available in library folders"), appearance_group_box);
	QCheckBox* hl_above_anime_box = new QCheckBox(tr("Display highlighted anime above others"), appearance_group_box);
	hl_above_anime_box->setEnabled((hl_anime_box->checkState() == Qt::Unchecked) ? 0 : 1);
	hl_above_anime_box->setStyleSheet("margin-left: 10px;");

	connect(hl_anime_box, &QCheckBox::stateChanged, this, [hl_above_anime_box](int state){
		hl_above_anime_box->setEnabled(state);
	});

	/* Appearance */
	QVBoxLayout* appearance_layout = new QVBoxLayout;
	appearance_layout->addWidget(lang_combo_box_label);
	appearance_layout->addWidget(lang_combo_box);
	appearance_layout->addWidget(hl_anime_box);
	appearance_layout->addWidget(hl_above_anime_box);
	appearance_group_box->setLayout(appearance_layout);

	QGroupBox* progress_group_box = new QGroupBox(tr("Progress"), result);
	progress_group_box->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QCheckBox* display_aired_episodes = new QCheckBox(tr("Display aired episodes (estimated)"), progress_group_box);
	QCheckBox* display_available_episodes = new QCheckBox(tr("Display available episodes in library folders"), progress_group_box);

	QVBoxLayout* progress_layout = new QVBoxLayout;
	progress_layout->addWidget(display_aired_episodes);
	progress_layout->addWidget(display_available_episodes);
	progress_group_box->setLayout(progress_layout);

	QVBoxLayout* full_layout = new QVBoxLayout;
	full_layout->addWidget(actions_group_box);
	full_layout->addWidget(appearance_group_box);
	full_layout->addWidget(progress_group_box);
	full_layout->addStretch();
	result->setLayout(full_layout);
	return result;
}

void SettingsPageApplication::SaveInfo() {

}

SettingsPageApplication::SettingsPageApplication(QWidget* parent)
	: SettingsPage(parent, tr("Application")) {
	AddTab(CreateAnimeListPage(), tr("Anime list"));
}
