#ifndef __date_h
#define __date_h
#include <cstdint>
#include <QDate>
class Date {
	public:
		Date();
		Date(int32_t y);
		Date(int32_t y, int8_t m, int8_t d);
		void SetYear(int32_t y);
		void SetMonth(int8_t m);
		void SetDay(int8_t d);
		int32_t GetYear() const;
		int8_t GetMonth() const;
		int8_t GetDay() const;
		QDate GetAsQDate();
		bool operator< (const Date& other) const;
		bool operator> (const Date& other) const;
		bool operator<= (const Date& other) const;
		bool operator>= (const Date& other) const;

	private:
		int32_t year = -1;
		int8_t month = -1;
		int8_t day = -1;
};
#endif // __date_h
