#ifndef __settings_h
#define __settings_h
#include <QWidget>
#include <QDialog>
#include <QTabWidget>
#include <QLabel>
#include <QLineEdit>
#include <QComboBox>
#include <QHBoxLayout>
#include "sidebar.h"
class SettingsPage : public QWidget {
	Q_OBJECT

	public:
		SettingsPage(QWidget* parent = nullptr, QString title = "");
		void SetTitle(QString title);
		virtual void SaveInfo();
		void AddTab(QWidget* tab, QString title = "");

	private:
		QLabel* page_title;
		QTabWidget* tab_widget;
};

class SettingsPageServices : public SettingsPage {
	public:
		SettingsPageServices(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateMainPage();
		QWidget* CreateAniListPage();
		QLineEdit* username_entry;
		QComboBox* sync_combo_box;
};

class SettingsPageApplication : public SettingsPage {
	public:
		SettingsPageApplication(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateAnimeListPage();
};

class SettingsDialog : public QDialog {
	Q_OBJECT

	public:
		SettingsDialog(QWidget* parent = nullptr);
		QWidget* CreateServicesMainPage(QWidget* parent);
		void OnSidebar(QListWidgetItem* item);
		void OnOK();

	private:
		std::vector<SettingsPage*> pages;
		QHBoxLayout* layout;
		SideBar* sidebar;
};
#endif // __settings_h