#ifndef MINORI_GUI_PAGES_NOW_PLAYING_H_
#define MINORI_GUI_PAGES_NOW_PLAYING_H_

#include "gui/widgets/anime_info.h"
#include "gui/widgets/poster.h"
#include "gui/widgets/sidebar.h"
#include "gui/widgets/text.h"

#include <QFrame>
#include <QStackedWidget>
#include <QTimer>

#include <memory>
#include <unordered_map>
#include <cstdint>


namespace Anime {
class Anime;
}

namespace anitomy {
class Elements;
}

/* -------------------------------------------------------------- */
/* this is kinda ugly. */

namespace NowPlayingPages {

class Default : public QWidget {
	Q_OBJECT

public:
	Default(QWidget* parent = nullptr);

private:
	TextWidgets::Title title_;
};

class Playing : public QWidget {
	Q_OBJECT

public:
	Playing(QWidget* parent = nullptr);
	bool SetPlayingAnime(const Anime::Anime& anime, const anitomy::Elements& info);
	int GetPlayingAnime();
	int GetPlayingEpisode();

private:
	int _id = 0;
	int _episode = 0;

	QWidget _main;
	TextWidgets::Title _title;
	AnimeInfoWidget _info;

	QWidget _sidebar;
	Poster _poster;
};

} // namespace NowPlayingPages

/* -------------------------------------------------------------- */
/* the full page */

class NowPlayingPage final : public QFrame {
	Q_OBJECT

public:
	NowPlayingPage(QWidget* parent = nullptr);
	void SetDefault();
	void SetPlaying(const Anime::Anime& anime, const anitomy::Elements& episodes);
	int GetPlayingId();

private slots:
	void TimerDone();

private:
	enum class Subpages {
		Default = 0,
		Playing = 1,
	};

	QStackedWidget stack_;
	/* Time the episode started playing (roughly)
	 * This is -1 if there is no episode playing */
	std::int64_t timer_ = -1;

	NowPlayingPages::Default default_;
	NowPlayingPages::Playing playing_;
};

#endif // MINORI_GUI_PAGES_NOW_PLAYING_H_
