#include "track/media.h"
#include "core/filesystem.h"
#include "core/session.h"
#include "core/strings.h"

#include <QFile>
#include <QTextStream>

#include <filesystem>
#include <string>
#include <unordered_map>
#include <vector>

#include <iostream>

#include "animone.h"

namespace Track {
namespace Media {

static bool GetCurrentlyPlayingResults(std::vector<animone::Result> &results)
{
	std::vector<animone::Player> players;

	players.reserve(session.config.recognition.players.size());
	for (const auto &[enabled, player] : session.config.recognition.players)
		if (enabled && player.type == animone::PlayerType::Default)
			players.push_back(player);

	return animone::GetResults(players, results);
}

/* The results from this function are KIND OF guaranteed to be UTF-8;
 * more specifically any files returned are UTF-8 as required by the C++
 * standard. However, window titles are not, and for some obscure X11
 * window managers, WILL not be in UTF-8. I don't care enough about this
 * to do anything about it though. */
bool GetCurrentlyPlaying(std::vector<std::string> &vec)
{
	std::vector<animone::Result> results;

	if (!GetCurrentlyPlayingResults(results))
		return false;

	bool success = false;

	for (const auto &result : results) {
		for (const auto &media : result.media) {
			for (const auto &info : media.information) {
				switch (info.type) {
					case animone::MediaInfoType::File:
						vec.push_back(std::filesystem::path(info.value).filename().u8string());
						success |= true;
						break;
					case animone::MediaInfoType::Title:
						vec.push_back(info.value);
						success |= true;
						break;
					case animone::MediaInfoType::Tab: break;
					case animone::MediaInfoType::Url: break;
					default: break;
				}
			}
		}
	}

	return success;
}

} // namespace Media
} // namespace Track
