#ifndef __core__date_h
#define __core__date_h

#include "json.h"
#include <QDate>
#include <cstdint>

class Date {
	public:
		Date();
		Date(unsigned int y);
		Date(unsigned int y, unsigned int m, unsigned int d);
		Date(const QDate& date);
		bool IsValid() const;
		void SetYear(unsigned int y);
		void SetMonth(unsigned int m);
		void SetDay(unsigned int d);
		void VoidYear();
		void VoidMonth();
		void VoidDay();
		unsigned int GetYear() const;
		unsigned int GetMonth() const;
		unsigned int GetDay() const;
		QDate GetAsQDate() const;
		nlohmann::json GetAsAniListJson() const;
		bool operator<(const Date& other) const;
		bool operator>(const Date& other) const;
		bool operator<=(const Date& other) const;
		bool operator>=(const Date& other) const;

	private:
		/* note: it might be worth it to change these all to int, as
		   large bit precisions aren't exactly useful here... */
		std::shared_ptr<unsigned int> year;
		std::shared_ptr<unsigned int> month;
		std::shared_ptr<unsigned int> day;
};

#endif // __core__date_h
