#ifndef MINORI_CORE_ANIME_DB_H_
#define MINORI_CORE_ANIME_DB_H_

#include "core/anime.h"
#include "json/json_fwd.hpp"
#include <string>
#include <unordered_map>

namespace Anime {

class Database {
public:
	std::unordered_map<int, Anime> items;
	size_t GetTotalAnimeAmount() const;
	size_t GetTotalEpisodeAmount() const;
	size_t GetTotalWatchedAmount() const;
	size_t GetTotalPlannedAmount() const;
	double GetAverageScore() const;
	double GetScoreDeviation() const;
	size_t GetListsAnimeAmount(ListStatus status) const;
	int LookupAnimeTitle(const std::string& title) const;

	bool GetDatabaseAsJSON(nlohmann::json& json) const;
	bool SaveDatabaseToDisk() const;

	bool ParseDatabaseJSON(const nlohmann::json& json);
	bool LoadDatabaseFromDisk();

	/* These are here to make sure that our service IDs don't collide
	 * and make the whole thing go boom. */
	int GetUnusedId() const;
	int LookupServiceId(Service service, const std::string& id_to_find) const;
	int LookupServiceIdOrUnused(Service service, const std::string& id_to_find) const;

	/* when syncing we don't want to keep deleted anime */
	void RemoveAllUserData();

	std::vector<int> GetAllAnimeForSeason(Season season);
};

extern Database db;

} // namespace Anime

#endif // MINORI_CORE_ANIME_DB_H_
