#include "window.h"
#include "anime.h"
#include "information.h"
#include "ui_utils.h"
#include "string_utils.h"

#include <QDialogButtonBox>

void InformationDialog::OnOK() {
	model->UpdateAnime(*anime);
	QDialog::accept();
}

InformationDialog::InformationDialog(Anime& a, AnimeListWidgetModel* model, QWidget* parent)
                                   : QDialog(parent)
                                     {
	this->model = model;
	this->anime = &a;
	setFixedSize(842, 613);
	setWindowTitle(tr("Anime Information"));
	setWindowFlags(Qt::Dialog | Qt::CustomizeWindowHint | Qt::WindowTitleHint | Qt::WindowCloseButtonHint);
	setObjectName("infodiag");
	QWidget* widget = new QWidget(this);
	widget->resize(842-175, 530);
	widget->move(175, 0);
	widget->setStyleSheet(UiUtils::IsInDarkMode() ? "" : "background-color: white");
	widget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
	QPlainTextEdit* anime_title = new QPlainTextEdit(QString::fromWCharArray(anime->title.english.c_str()), widget);
	anime_title->setReadOnly(true);
	anime_title->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	anime_title->setWordWrapMode(QTextOption::NoWrap);
	anime_title->setFrameShape(QFrame::NoFrame);
	anime_title->resize(636, 28);
	anime_title->move(0, 12);
	anime_title->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
	anime_title->setStyleSheet("font-size: 16px; color: blue");
	QTabWidget* tabbed_widget = new QTabWidget(widget);
	tabbed_widget->resize(636, 485);
	tabbed_widget->move(0, 45);
	tabbed_widget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
	QWidget* main_information_widget = new QWidget(tabbed_widget);
	UiUtils::CreateSelectableTextParagraph(main_information_widget, "Alternative titles", "-", QPoint(6, 6), QSize(636-18, 56));
	QString details_data("");
	QTextStream details_data_s(&details_data);
	details_data_s << AnimeFormatToStringMap[anime->type].c_str() << "\n"
	               << anime->episodes << "\n"
	               << AnimeAiringToStringMap[anime->airing].c_str() << "\n"
	               << AnimeSeasonToStringMap[anime->season].c_str() << " " << anime->air_date.GetYear() << "\n"
	               << StringUtils::Implode(anime->genres, ", ").c_str() << "\n"
	               << anime->audience_score << "%\n";
	UiUtils::CreateTextParagraphWithLabels(main_information_widget, "Details", "Type:\nEpisodes:\nStatus:\nSeason:\nGenres:\nScore:", details_data, QPoint(6, 62), QSize(636-18, 142));
	UiUtils::CreateSelectableTextParagraph(main_information_widget, "Synopsis", QString::fromWCharArray(anime->synopsis.c_str()), QPoint(6, 202), QSize(636-18, 253));
	tabbed_widget->addTab(main_information_widget, "Main information");
	QWidget* settings_widget = new QWidget(tabbed_widget);
	
	QDialogButtonBox* button_box = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel, this);
	connect(button_box, &QDialogButtonBox::accepted, this, &OnOK);
	connect(button_box, &QDialogButtonBox::rejected, this, &QDialog::reject);
	QVBoxLayout* buttons_layout = new QVBoxLayout(widget);
	buttons_layout->addWidget(widget, 0, Qt::AlignTop);
	buttons_layout->addWidget(button_box, 0, Qt::AlignBottom);
	// this should probably be win32-only
	setStyleSheet(UiUtils::IsInDarkMode() ? "" : "QDialog#infodiag{background-color: white;}");
	setLayout(buttons_layout);
}

#include "moc_information.cpp"
