#ifndef __statistics_h
#define __statistics_h
class Statistics;

class StatisticsTimer : public wxTimer {
	public:
		StatisticsTimer(Statistics* caller);
		virtual void Notify();

	private:
		Statistics* statistics;
};

class Statistics {
	public:
		Statistics(page_t* page, wxPanel* frame);
		void UpdateStatistics();

	private:
		std::string MinutesToDateString(int minutes);

		wxPanel* panel;
		AnimeListPage* anime_list;
		wxStaticText* anime_list_data;

		wxStaticText* score_distribution_title;
		wxStaticText* score_distribution_labels;
		//wxStaticText* score_distribution_graph; // how am I gonna do this

		/* we don't HAVE a local database (yet ;)) */
		//wxStaticText* local_database_title;
		//wxStaticText* local_database_labels;
		//wxStaticText* local_database_data;

		wxStaticText* application_title;
		wxStaticText* application_labels;
		wxStaticText* application_data;
		StatisticsTimer* timer;
};
#endif // __statistics_h